/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.dialog.impl;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.config.KitsLang;

public class KitCreationDialog
extends Dialog<KitsModule> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Kits.Dialog.KitCreation.Title").text("Kit Creation");
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Kits.Dialog.KitCreation.Body").dialogElement(400, new String[]{"Enter an identifier for new kit."});
    private static final TextLocale INPUT_ID = LangEntry.builder((String)"Kits.Dialog.KitCreation.Input.ID").text("Kit Identifier");
    private static final String JSON_ID = "id";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull KitsModule module) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_ID, (TextLocale)INPUT_ID).maxLength(64).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            String id = nbtHolder.getText(JSON_ID).orElse(null);
            if (id == null) {
                return;
            }
            try {
                module.createKit(id);
            }
            catch (IllegalArgumentException exception) {
                module.sendPrefixed(KitsLang.KIT_CREATION_ERROR, (CommandSender)player, builder -> builder.with("%message%", exception::getMessage));
            }
            viewer.callback();
        }).build();
    }
}

