/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.dialog.impl;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.kits.model.Kit;

public class KitCooldownDialog
extends Dialog<Kit> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Kits.Dialog.KitCooldown.Title").text("Kit Cooldown");
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Kits.Dialog.KitCooldown.Body").dialogElement(400, new String[]{"Enter cooldown value."});
    private static final TextLocale INPUT_COOLDOWN = LangEntry.builder((String)"Kits.Dialog.KitCooldown.Input.Name").text("Cooldown");
    private static final String JSON_COOLDOWN = "cooldown";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Kit kit) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_COOLDOWN, (TextLocale)INPUT_COOLDOWN).maxLength(12).initial(String.valueOf(kit.definition().getCooldown())).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            int cooldown = nbtHolder.getInt(JSON_COOLDOWN).orElse(kit.definition().getCooldown());
            kit.definition().setCooldown(cooldown);
            kit.markDirty();
            viewer.callback();
        }).build();
    }
}

