/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.dialog.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedTextDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.kits.model.Kit;

public class KitCommandsDialog
extends Dialog<Kit> {
    private static final int COMMANDS_AMOUNT = 5;
    private static final TextLocale TITLE = LangEntry.builder((String)"Kits.Dialog.KitCommands.Title").text(KitCommandsDialog.title("Kit", "Commands"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Kits.Dialog.KitCommands.Body").dialogElement(400, new String[]{"Enter up to " + TagWrappers.SOFT_YELLOW.wrap("5 commands") + " that are executed when a player receives the kit. The commands will be executed in the same order as the fields listed below.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " Use the " + TagWrappers.SOFT_YELLOW.wrap("%player_name%") + " placeholder to insert the name of the player who received the kit.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " You can use the internal " + TagWrappers.SOFT_YELLOW.wrap("Kit") + " placeholders: click " + ((SimpleTagWrapper)TagWrappers.OPEN_URL.with("https://nightexpressdev.com/")).wrap(TagWrappers.SOFT_GREEN.and((TagWrapper)TagWrappers.UNDERLINED).wrap("HERE")) + " to view documentation.", "", TagWrappers.SOFT_YELLOW.wrap("\u2192") + " You can use any placeholders from the " + TagWrappers.SOFT_YELLOW.wrap("PlaceholderAPI") + " plugin."});
    private static final TextLocale INPUT_COMMAND = LangEntry.builder((String)"Kits.Dialog.KitCommands.Input.Command").text("Command " + TagWrappers.SOFT_YELLOW.wrap("#%s"));
    private static final Function<Integer, String> JSON_COMMAND = index -> "command_" + index;

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Kit kit) {
        ArrayList<WrappedTextDialogInput> inputs = new ArrayList<WrappedTextDialogInput>();
        List<String> currentCommands = kit.definition().getCommands();
        int size = Math.max(5, currentCommands.size());
        for (int index = 0; index < size; ++index) {
            inputs.add(DialogInputs.text((String)JSON_COMMAND.apply(index), (String)INPUT_COMMAND.text().formatted(String.valueOf(index + 1))).initial(currentCommands.size() > index ? currentCommands.get(index) : "").maxLength(400).width(300).build());
        }
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(inputs).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                ArrayList<String> commands = new ArrayList<String>();
                for (int index = 0; index < size; ++index) {
                    nbtHolder.getText(JSON_COMMAND.apply(index)).filter(Predicate.not(String::isBlank)).ifPresent(command -> {
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                        }
                        commands.add((String)command);
                    });
                }
                kit.definition().setCommands(commands);
                kit.markDirty();
                viewer.callback();
            });
        });
    }
}

