/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.items.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.SuggestionsProvider;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandArguments;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.items.ItemsLang;
import su.nightexpress.sunlight.module.items.ItemsModule;
import su.nightexpress.sunlight.module.items.ItemsPerms;

public class LoreCommandsProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION_ROOT = ItemsPerms.COMMAND.permission("lore.root");
    private static final Permission PERMISSION_ADD = ItemsPerms.COMMAND.permission("lore.add");
    private static final Permission PERMISSION_INSERT = ItemsPerms.COMMAND.permission("lore.insert");
    private static final Permission PERMISSION_CLEAR = ItemsPerms.COMMAND.permission("lore.clear");
    private static final Permission PERMISSION_REMOVE = ItemsPerms.COMMAND.permission("lore.remove");
    private static final String COMMAND_ADD = "add";
    private static final String COMMAND_INSERT = "insert";
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_REMOVE = "remove";
    private final ItemsModule module;

    public LoreCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull ItemsModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_ADD, false, new String[]{"addlore"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_LORE_ADD_DESC)).permission(PERMISSION_ADD)).withArguments(new ArgumentNodeBuilder[]{Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT)}).executes(this::addOrInsertLoreLine));
        this.registerLiteral(COMMAND_INSERT, false, new String[]{"inslore"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_LORE_INSERT_DESC)).permission(PERMISSION_INSERT)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"position", (int)0, (int)99).localized(Lang.COMMAND_ARGUMENT_NAME_POSITION).suggestions(LoreCommandsProvider.loreIndexesSuggestions()), Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT)}).executes(this::addOrInsertLoreLine));
        this.registerLiteral(COMMAND_REMOVE, false, new String[]{"dellore"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_LORE_REMOVE_DESC)).permission(PERMISSION_REMOVE)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"position", (int)0, (int)99).optional().localized(Lang.COMMAND_ARGUMENT_NAME_POSITION).suggestions(LoreCommandsProvider.loreIndexesSuggestions())}).executes(this::removeLoreLine));
        this.registerLiteral(COMMAND_CLEAR, false, new String[]{"clearlore"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_LORE_CLEAR_DESC)).permission(PERMISSION_CLEAR)).executes(this::clearLore));
        this.registerRoot("lore", true, new String[]{"itemlore", "lore", "il"}, Map.of(COMMAND_ADD, COMMAND_ADD, COMMAND_INSERT, COMMAND_INSERT, COMMAND_REMOVE, COMMAND_REMOVE, COMMAND_CLEAR, COMMAND_CLEAR), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_LORE_ROOT_DESC)).permission(PERMISSION_ROOT));
    }

    @NotNull
    private static SuggestionsProvider loreIndexesSuggestions() {
        return (reader, context) -> Optional.ofNullable(context.getPlayer()).map(player -> player.getInventory().getItemInMainHand()).filter(itemStack -> !itemStack.getType().isAir()).map(ItemUtil::getLoreSerialized).map(List::size).map(size -> IntStream.range(0, size).boxed().map(String::valueOf).toList()).orElse(Collections.emptyList());
    }

    private boolean addOrInsertLoreLine(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            String text = arguments.getString("text");
            int pos = arguments.contains("position") ? arguments.getInt("position") : -1;
            List lore = ItemUtil.getLoreSerialized((ItemStack)itemStack);
            if (pos >= 0 && pos < lore.size()) {
                lore.add(pos, text);
            } else {
                lore.add(text);
            }
            ItemUtil.setLore((ItemStack)itemStack, (List)lore);
            this.module.sendPrefixed(ItemsLang.ITEM_LORE_ADD_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%text%", () -> text));
            return true;
        });
    }

    private boolean removeLoreLine(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            int index = arguments.getInt("position");
            List lore = ItemUtil.getLoreSerialized((ItemStack)itemStack);
            if (lore.isEmpty()) {
                this.module.sendPrefixed(ItemsLang.ERROR_ITEM_HAS_NO_LORE, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
                return false;
            }
            String result = index >= 0 && index < lore.size() ? (String)lore.remove(index) : (String)lore.removeLast();
            ItemUtil.setLore((ItemStack)itemStack, (List)lore);
            this.module.sendPrefixed(ItemsLang.ITEM_LORE_REMOVE_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%text%", () -> result));
            return true;
        });
    }

    private boolean clearLore(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            List lore = ItemUtil.getLoreSerialized((ItemStack)itemStack);
            if (lore.isEmpty()) {
                this.module.sendPrefixed(ItemsLang.ERROR_ITEM_HAS_NO_LORE, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
                return false;
            }
            ItemUtil.setLore((ItemStack)itemStack, new ArrayList());
            this.module.sendPrefixed(ItemsLang.ITEM_LORE_CLEAR_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
            return true;
        });
    }
}

