/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.items.command;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandArguments;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.items.ItemsLang;
import su.nightexpress.sunlight.module.items.ItemsModule;
import su.nightexpress.sunlight.module.items.ItemsPerms;
import su.nightexpress.sunlight.module.items.ItemsSettings;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.utils.ItemStackUtils;

public class ItemCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_AMOUNT = "amount";
    private static final String COMMAND_DAMAGE = "damage";
    private static final String COMMAND_ENCHANT = "enchant";
    private static final String COMMAND_DISENCHANT = "disenchant";
    private static final String COMMAND_GET = "get";
    private static final String COMMAND_GIVE = "give";
    private static final String COMMAND_MODEL = "model";
    private static final String COMMAND_NAME = "name";
    private static final String COMMAND_POTION = "potion";
    private static final String COMMAND_REPAIR = "repair";
    private static final String COMMAND_SPAWN = "spawn";
    private static final String COMMAND_UNBREAKABLE = "unbreakable";
    private final ItemsModule module;
    private final ItemsSettings settings;
    private final UserManager userManager;

    public ItemCommandProvider(@NotNull SunLightPlugin plugin, @NotNull ItemsModule module, @NotNull ItemsSettings settings, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_AMOUNT, false, new String[]{"itemamount"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_AMOUNT_DESC)).permission(ItemsPerms.COMMAND_ITEM_AMOUNT)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)COMMAND_AMOUNT, (int)1, (int)64).optional().localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1", "8", "16", "32", "64"}))}).executes(this::setItemStackSize));
        this.registerLiteral(COMMAND_DAMAGE, false, new String[]{"itemdamage"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_DAMAGE_DESC)).permission(ItemsPerms.COMMAND_ITEM_DAMAGE)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)COMMAND_AMOUNT, (int)0).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Optional.ofNullable(context.getPlayer()).map(player -> player.getInventory().getItemInMainHand()).map(itemStack -> Lists.newList((Object[])new String[]{"0", String.valueOf(itemStack.getType().getMaxDurability())})).orElse(Collections.emptyList()))}).executes(this::damageOrRepairItem));
        this.registerLiteral(COMMAND_ENCHANT, false, new String[]{"addenchant"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_ENCHANT_DESC)).permission(ItemsPerms.COMMAND_ITEM_ENCHANT)).withArguments(new ArgumentNodeBuilder[]{Arguments.enchantment((String)COMMAND_ENCHANT).suggestions((reader, context) -> Optional.ofNullable(context.getPlayer()).map(player -> player.getInventory().getItemInMainHand()).map(itemStack -> BukkitThing.getEnchantments().stream().filter(enchantment -> enchantment.canEnchantItem(itemStack) || context.getSender().hasPermission(ItemsPerms.COMMAND_ITEM_ENCHANT_UNLIMITED)).map(BukkitThing::getAsString).toList()).orElse(Collections.emptyList())), Arguments.integer((String)"level", (int)1, (int)1000).suggestions((reader, context) -> Optional.ofNullable(BukkitThing.getEnchantment((String)reader.getArgument(reader.getCursor() - 1))).map(enchantment -> context.getSender().hasPermission(ItemsPerms.COMMAND_ITEM_ENCHANT_UNLIMITED) ? Math.max(10, enchantment.getMaxLevel()) : enchantment.getMaxLevel()).map(maxLevel -> IntStream.range(1, maxLevel + 1).boxed().map(String::valueOf).toList()).orElse(Collections.emptyList()))}).executes(this::enchantItem));
        this.registerLiteral(COMMAND_DISENCHANT, false, new String[]{"removeenchant"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_DISENCHANT_DESC)).permission(ItemsPerms.COMMAND_ITEM_DISENCHANT)).withArguments(new ArgumentNodeBuilder[]{Arguments.enchantment((String)COMMAND_ENCHANT).optional().suggestions((reader, context) -> Optional.ofNullable(context.getPlayer()).map(player -> player.getInventory().getItemInMainHand()).filter(itemStack -> !itemStack.getType().isAir()).map(itemStack -> itemStack.getEnchantments().keySet().stream().map(BukkitThing::getAsString).toList()).orElse(Collections.emptyList()))}).executes(this::disenchantItem));
        this.registerLiteral(COMMAND_GET, true, new String[]{"getitem"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_GET_DESC)).permission(ItemsPerms.COMMAND_ITEM_GET)).withArguments(new ArgumentNodeBuilder[]{Arguments.itemType((String)"item"), Arguments.integer((String)COMMAND_AMOUNT, (int)1).optional().localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1"}))}).executes(this::getItem));
        this.registerLiteral(COMMAND_GIVE, true, new String[]{"giveitem"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_GIVE_DESC)).permission(ItemsPerms.COMMAND_ITEM_GIVE)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.itemType((String)"item"), Arguments.integer((String)COMMAND_AMOUNT, (int)1).optional().localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1"}))}).withFlags(new String[]{"s"}).executes(this::giveItem));
        this.registerLiteral(COMMAND_MODEL, false, new String[]{"itemmodel"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_MODEL_DESC)).permission(ItemsPerms.COMMAND_ITEM_MODEL)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"value", (int)0)}).executes(this::setModelData));
        this.registerLiteral(COMMAND_NAME, true, new String[]{"rename"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_NAME_DESC)).permission(ItemsPerms.COMMAND_ITEM_NAME)).withArguments(new ArgumentNodeBuilder[]{Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT)}).executes(this::setItemName));
        this.registerLiteral(COMMAND_REPAIR, true, new String[]{COMMAND_REPAIR, "fix"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_REPAIR_DESC)).permission(ItemsPerms.COMMAND_ITEM_REPAIR)).executes(this::damageOrRepairItem));
        this.registerLiteral(COMMAND_SPAWN, false, new String[]{"dropitem"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_SPAWN_DESC)).permission(ItemsPerms.COMMAND_ITEM_SPAWN)).withArguments(new ArgumentNodeBuilder[]{Arguments.itemType((String)"item"), Arguments.decimal((String)"x").suggestions((reader, context) -> CommandArguments.getTargetPosSuggestions(context, Block::getX)), Arguments.decimal((String)"y").suggestions((reader, context) -> CommandArguments.getTargetPosSuggestions(context, block -> block.getY() + 1)), Arguments.decimal((String)"z").suggestions((reader, context) -> CommandArguments.getTargetPosSuggestions(context, Block::getZ)), Arguments.world((String)"world").optional(), Arguments.integer((String)COMMAND_AMOUNT, (int)1).optional().suggestions((reader, context) -> Lists.newList((Object[])new String[]{"1", "8", "16", "32", "64"}))}).executes(this::dropItemAtLocation));
        this.registerLiteral(COMMAND_UNBREAKABLE, true, new String[]{COMMAND_UNBREAKABLE}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_UNBREAKABLE_DESC)).permission(ItemsPerms.COMMAND_ITEM_UNBREAKABLE)).withArguments(new ArgumentNodeBuilder[]{Arguments.bool((String)"state").localized(Lang.COMMAND_ARGUMENT_NAME_STATE).optional()}).executes(this::setUnbreakable));
        this.registerRoot("item", true, new String[]{"item", "i"}, (Map<String, String> map) -> {
            map.put(COMMAND_AMOUNT, COMMAND_AMOUNT);
            map.put(COMMAND_DAMAGE, COMMAND_DAMAGE);
            map.put(COMMAND_ENCHANT, COMMAND_ENCHANT);
            map.put(COMMAND_DISENCHANT, COMMAND_DISENCHANT);
            map.put(COMMAND_GET, COMMAND_GET);
            map.put(COMMAND_GIVE, COMMAND_GIVE);
            map.put(COMMAND_MODEL, COMMAND_MODEL);
            map.put(COMMAND_NAME, COMMAND_NAME);
            map.put(COMMAND_REPAIR, COMMAND_REPAIR);
            map.put(COMMAND_SPAWN, COMMAND_SPAWN);
            map.put(COMMAND_UNBREAKABLE, COMMAND_UNBREAKABLE);
        }, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(ItemsLang.COMMAND_ITEM_ROOT_DESC)).permission(ItemsPerms.COMMAND_ITEM_ROOT));
        this.registerLiteral(COMMAND_POTION, false, new String[]{"addpotioneffect"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ItemsLang.COMMAND_ITEM_POTION_ADD_DESC)).permission(ItemsPerms.COMMAND_ITEM_POTION)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.effect("type", effectType -> true), Arguments.integer((String)"level", (int)0).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"0", "1", "5", "10", "127"})), Arguments.integer((String)"time", (int)1).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"60", "300", "600", "3600"}))}).executes(this::addPotionEffect));
    }

    private boolean setItemStackSize(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            int maxStackSize = itemStack.getMaxStackSize();
            if (maxStackSize == 1) {
                this.module.sendPrefixed(ItemsLang.ERROR_ITEM_NOT_STACKABLE, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
                return false;
            }
            int amount = arguments.getInt(COMMAND_AMOUNT, ((Integer)this.settings.defaultAmountValue.get()).intValue());
            int stackSize = Math.min(maxStackSize, amount);
            itemStack.setAmount(stackSize);
            this.module.sendPrefixed(ItemsLang.ITEM_SET_AMOUNT_FEEDBACK, context.getSender(), builder -> builder.with("%amount%", () -> String.valueOf(stackSize)).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
            return true;
        });
    }

    private boolean damageOrRepairItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            MessageLocale locale;
            int amount;
            if (!ItemStackUtils.isDamageable(itemStack)) {
                this.module.sendPrefixed(ItemsLang.ERROR_ITEM_NOT_DAMAGEABLE, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
                return false;
            }
            if (arguments.contains(COMMAND_AMOUNT)) {
                amount = arguments.getInt(COMMAND_AMOUNT);
                locale = ItemsLang.ITEM_SET_DAMAGE_FEEDBACK;
            } else {
                amount = 0;
                locale = ItemsLang.ITEM_REPAIRED_FEEDBACK;
            }
            int result = ItemStackUtils.setItemDamage(itemStack, amount);
            this.module.sendPrefixed(locale, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%amount%", () -> String.valueOf(result)));
            return true;
        });
    }

    private boolean enchantItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            boolean hasBypass = context.getSender().hasPermission(ItemsPerms.COMMAND_ITEM_ENCHANT_UNLIMITED);
            Enchantment enchantment = arguments.getEnchantment(COMMAND_ENCHANT);
            if (!hasBypass && !enchantment.canEnchantItem(itemStack)) {
                this.module.sendPrefixed(ItemsLang.ITEM_ADD_ENCHANT_INCOMPATIBLE, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%enchantment%", () -> LangUtil.getSerializedName((Enchantment)enchantment)).with("%name%", () -> LangUtil.getSerializedName((Enchantment)enchantment)));
                return false;
            }
            int level = arguments.getInt("level", 1);
            if (!hasBypass && level > enchantment.getMaxLevel()) {
                this.module.sendPrefixed(ItemsLang.ITEM_ADD_ENCHANT_LEVEL_OVERFLOW, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%enchantment%", () -> LangUtil.getSerializedName((Enchantment)enchantment)).with("%name%", () -> LangUtil.getSerializedName((Enchantment)enchantment)).with("%level%", () -> LangUtil.getEnchantmentLevelLang((int)level)));
                return false;
            }
            ItemStackUtils.addEnchantment(itemStack, enchantment, level);
            this.module.sendPrefixed(ItemsLang.ITEM_ADD_ENCHANT_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%enchantment%", () -> LangUtil.getSerializedName((Enchantment)enchantment)).with("%name%", () -> LangUtil.getSerializedName((Enchantment)enchantment)).with("%level%", () -> LangUtil.getEnchantmentLevelLang((int)level)));
            return true;
        });
    }

    private boolean disenchantItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            if (arguments.contains(COMMAND_ENCHANT)) {
                Enchantment enchantment = arguments.getEnchantment(COMMAND_ENCHANT);
                if (!itemStack.containsEnchantment(enchantment)) {
                    this.module.sendPrefixed(ItemsLang.ITEM_DISENCHANT_SINGLE_NOTHING, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%enchantment%", () -> LangUtil.getSerializedName((Enchantment)enchantment)));
                    return false;
                }
                int oldLevel = itemStack.getEnchantmentLevel(enchantment);
                ItemStackUtils.removeEnchantment(itemStack, enchantment);
                this.module.sendPrefixed(ItemsLang.ITEM_DISENCHANT_SINGLE_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%enchantment%", () -> LangUtil.getSerializedName((Enchantment)enchantment)).with("%level%", () -> LangUtil.getEnchantmentLevelLang((int)oldLevel)));
            } else {
                if (itemStack.getEnchantments().isEmpty()) {
                    this.module.sendPrefixed(ItemsLang.ITEM_DISENCHANT_FULL_NOTHING, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
                    return false;
                }
                ItemStackUtils.removeEnchantments(itemStack);
                this.module.sendPrefixed(ItemsLang.ITEM_DISENCHANT_FULL_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
            }
            return true;
        });
    }

    private boolean getItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        ItemStack itemStack = this.createItem(arguments);
        Players.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack});
        this.module.sendPrefixed(ItemsLang.ITEM_GET_FEEDBACK, context.getSender(), builder -> builder.with("%amount%", () -> String.valueOf(itemStack.getAmount())).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%type%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
        return true;
    }

    private boolean giveItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            ItemStack itemStack = this.createItem(arguments);
            Players.addItem((Player)target, (ItemStack[])new ItemStack[]{itemStack});
            if (!target.isOnline()) {
                target.saveData();
            }
            this.module.sendPrefixed(ItemsLang.ITEM_GIVE_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)).with("%amount%", () -> String.valueOf(itemStack.getAmount())).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%type%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(ItemsLang.ITEM_GIVE_NOTIFY, (CommandSender)target, builder -> builder.with("%amount%", () -> String.valueOf(itemStack.getAmount())).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%type%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
            }
        });
    }

    private boolean setModelData(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            int modelData = arguments.getInt("value");
            ItemUtil.editMeta((ItemStack)itemStack, meta -> meta.setCustomModelData(Integer.valueOf(modelData)));
            this.module.sendPrefixed(ItemsLang.COMMAND_ITEM_MODEL_DONE, context.getSender(), builder -> builder.with("%amount%", () -> String.valueOf(modelData)).with("%name%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
            return true;
        });
    }

    private boolean setItemName(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            String name = arguments.getString("text");
            String oldName = ItemUtil.getNameSerialized((ItemStack)itemStack);
            ItemUtil.setCustomName((ItemStack)itemStack, (String)name);
            this.module.sendPrefixed(ItemsLang.ITEM_RENAME_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> oldName).with("%name%", () -> name));
            return true;
        });
    }

    private boolean addPotionEffect(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            ItemMeta meta = itemStack.getItemMeta();
            if (!(meta instanceof PotionMeta)) {
                this.module.sendPrefixed(ItemsLang.ERROR_ITEM_NOT_POTION, context.getSender());
                return false;
            }
            PotionMeta potionMeta = (PotionMeta)meta;
            PotionEffectType effectType = (PotionEffectType)arguments.get("type", PotionEffectType.class);
            int amplifier = arguments.getInt("level");
            if (amplifier < 0) {
                potionMeta.removeCustomEffect(effectType);
            } else {
                int duration = arguments.getInt("time");
                if (duration <= 0) {
                    return false;
                }
                PotionEffect pEffect = new PotionEffect(effectType, duration, amplifier);
                potionMeta.addCustomEffect(pEffect, true);
            }
            this.module.sendPrefixed(ItemsLang.COMMAND_ITEM_POTION_ADD_DONE, context.getSender());
            itemStack.setItemMeta(meta);
            return true;
        });
    }

    private boolean dropItemAtLocation(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        ItemStack copy;
        ItemStack itemStack = this.createItem(arguments);
        World world = this.getWorld(context, arguments, "world");
        if (world == null) {
            return false;
        }
        double x = arguments.getDouble("x");
        double y = arguments.getDouble("y");
        double z = arguments.getDouble("z");
        Location location = new Location(world, x, y, z);
        int maxStackSize = itemStack.getMaxStackSize();
        for (int amountToDrop = itemStack.getAmount(); amountToDrop > 0; amountToDrop -= copy.getAmount()) {
            copy = new ItemStack(itemStack);
            copy.setAmount(Math.min(maxStackSize, amountToDrop));
            world.dropItemNaturally(location, copy);
        }
        this.module.sendPrefixed(ItemsLang.ITEM_DROP_FEEDBACK, context.getSender(), builder -> builder.with("%amount%", () -> String.valueOf(itemStack.getAmount())).with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%type%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with(CommonPlaceholders.LOCATION.resolver((Object)location)));
        return true;
    }

    private boolean setUnbreakable(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return CommandArguments.handleItemInHandOrError(context, (player, itemStack) -> {
            if (!ItemStackUtils.isDamageable(itemStack)) {
                this.module.sendPrefixed(ItemsLang.ERROR_ITEM_NOT_DAMAGEABLE, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)));
                return false;
            }
            ItemUtil.editMeta((ItemStack)itemStack, meta -> {
                boolean state = arguments.contains("state") ? arguments.getBoolean("state") : !meta.isUnbreakable();
                meta.setUnbreakable(state);
                this.module.sendPrefixed(ItemsLang.ITEM_SET_UNBREAKABLE_FEEDBACK, context.getSender(), builder -> builder.with("%item%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(meta.isUnbreakable())));
            });
            return true;
        });
    }

    @NotNull
    private ItemStack createItem(@NotNull ParsedArguments arguments) {
        Material material = arguments.getMaterial("item");
        int amount = arguments.getInt(COMMAND_AMOUNT, 1);
        int maxStackSize = material.getMaxStackSize();
        int maxStacks = (Integer)this.settings.maxItemStacksAmount.get();
        int expectedStacks = (int)Math.ceil((double)amount / (double)maxStackSize);
        int itemAmount = expectedStacks > maxStacks ? maxStackSize * maxStacks : amount;
        return new ItemStack(material, itemAmount);
    }
}

