/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.inventories.command;

import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.inventories.InventoriesModule;
import su.nightexpress.sunlight.module.inventories.InventoriesPerms;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.utils.ItemStackUtils;

public class InventoryCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_FILL = "fill";
    private static final String COMMAND_OPEN = "open";
    private static final String COMMAND_REPAIR = "repair";
    private static final Permission PERMISSION_ROOT = InventoriesPerms.COMMAND.permission("inventory.root");
    private static final Permission PERMISSION_CLEAR = InventoriesPerms.COMMAND.permission("inventory.clear");
    private static final Permission PERMISSION_CLEAR_OTHERS = InventoriesPerms.COMMAND.permission("inventory.clear.others");
    private static final Permission PERMISSION_COPY = InventoriesPerms.COMMAND.permission("inventory.copy");
    private static final Permission PERMISSION_COPY_OTHERS = InventoriesPerms.COMMAND.permission("inventory.copy.others");
    private static final Permission PERMISSION_FILL = InventoriesPerms.COMMAND.permission("inventory.fill");
    private static final Permission PERMISSION_OPEN = InventoriesPerms.COMMAND.permission("inventory.open");
    private static final Permission PERMISSION_REPAIR = InventoriesPerms.COMMAND.permission("inventory.repair");
    private static final Permission PERMISSION_REPAIR_OTHERS = InventoriesPerms.COMMAND.permission("inventory.repair.others");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Inventory.Root.Desc").text("Inventory management commands.");
    private static final TextLocale DESCRIPTION_CLEAR = LangEntry.builder((String)"Command.Inventory.Clear.Desc").text("Clear inventory.");
    private static final TextLocale DESCRIPTION_COPY = LangEntry.builder((String)"Command.Inventory.Copy.Desc").text("Copy player's inventory.");
    private static final TextLocale DESCRIPTION_FILL = LangEntry.builder((String)"Command.Inventory.Fill.Desc").text("Fill player's inventory with certain item.");
    private static final TextLocale DESCRIPTION_OPEN = LangEntry.builder((String)"Command.Inventory.Open.Desc").text("Open player's inventory.");
    private static final TextLocale DESCRIPTION_REPAIR = LangEntry.builder((String)"Command.Inventory.Repair.Desc").text("Repair all items in the inventory.");
    private static final MessageLocale MESSAGE_CLEAR_FEEDBACK = LangEntry.builder((String)"Command.Inventory.Clear.Done.Target").chatMessage(Sound.BLOCK_FIRE_EXTINGUISH, new String[]{TagWrappers.GRAY.wrap("You have cleared " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s inventory.")});
    private static final MessageLocale MESSAGE_CLEAR_NOTIFY = LangEntry.builder((String)"Command.Inventory.Clear.Done.Notify").chatMessage(Sound.BLOCK_FIRE_EXTINGUISH, new String[]{TagWrappers.GRAY.wrap("Your inventory has been cleared.")});
    private static final MessageLocale MESSAGE_COPY_NOTIFY = LangEntry.builder((String)"Command.Inventory.Copy.Done.Notify").chatMessage(Sound.ITEM_ARMOR_EQUIP_LEATHER, new String[]{TagWrappers.GRAY.wrap("You have copied " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s inventory contents.")});
    private static final MessageLocale MESSAGE_COPY_FEEDBACK = LangEntry.builder((String)"Command.Inventory.Copy.Done.Target").chatMessage(Sound.ITEM_ARMOR_EQUIP_LEATHER, new String[]{TagWrappers.GRAY.wrap("You have copied " + TagWrappers.WHITE.wrap("%source%") + "'s inventory contents to " + TagWrappers.WHITE.wrap("%target%") + "'s inventory.")});
    private static final MessageLocale MESSAGE_FILL_FEEDBACK = LangEntry.builder((String)"Command.Inventory.Fill.Done").chatMessage(Sound.ENTITY_ITEM_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have filled up all empty slots in the " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s inventory with " + TagWrappers.SOFT_YELLOW.wrap("%item%") + ".")});
    private static final MessageLocale MESSAGE_OPEN_FEEDBACK = LangEntry.builder((String)"Command.Inventory.Open.Done").chatMessage(Sound.BLOCK_CHEST_OPEN, new String[]{TagWrappers.GRAY.wrap("You have opened " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s inventory.")});
    private static final MessageLocale MESSAGE_REPAIR_NOTIFY = LangEntry.builder((String)"Command.Inventory.Repair.Notify").chatMessage(Sound.BLOCK_ANVIL_USE, new String[]{TagWrappers.GRAY.wrap("All items in your inventory have been repaired.")});
    private static final MessageLocale MESSAGE_REPAIR_FEEDBACK = LangEntry.builder((String)"Command.Inventory.Repair.Target").chatMessage(Sound.BLOCK_ANVIL_USE, new String[]{TagWrappers.GRAY.wrap("You have repaired all items in the " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s inventory.")});
    private final InventoriesModule module;
    private final UserManager userManager;

    public InventoryCommandProvider(@NotNull SunLightPlugin plugin, @NotNull InventoriesModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_CLEAR, true, new String[]{"clearinv", "clearinventory", "ci"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_CLEAR)).permission(PERMISSION_CLEAR)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_CLEAR_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::clearInventory));
        this.registerLiteral(COMMAND_COPY, false, new String[]{"copyinv", "copyinventory"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_COPY)).permission(PERMISSION_COPY)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), ((ArgumentNodeBuilder)Arguments.playerName((String)"target").permission(PERMISSION_COPY_OTHERS)).optional()}).executes(this::copyInventory));
        this.registerLiteral(COMMAND_FILL, false, new String[]{"fillinv", "fillinventory"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_FILL)).permission(PERMISSION_FILL)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.itemType((String)"item")}).executes(this::fillInventory));
        this.registerLiteral(COMMAND_OPEN, true, new String[]{"openinv", "openinventory", "invsee"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION_OPEN)).permission(PERMISSION_OPEN)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player")}).executes(this::openInventory));
        this.registerLiteral(COMMAND_REPAIR, true, new String[]{"repairinv", "repairinventory", "fixall", "repairall"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_REPAIR)).permission(PERMISSION_REPAIR)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_REPAIR_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::repairInventoryItems));
        this.registerRoot("Inventory", true, new String[]{"inventory", "inv"}, Map.of(COMMAND_CLEAR, COMMAND_CLEAR, COMMAND_COPY, COMMAND_COPY, COMMAND_FILL, COMMAND_FILL, COMMAND_OPEN, COMMAND_OPEN, COMMAND_REPAIR, COMMAND_REPAIR), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    private boolean clearInventory(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        this.plugin.getSunNMS().getPlayerInventory(target).clear();
        if (!target.isOnline()) {
            target.saveData();
        }
        if (context.getSender() != target) {
            this.module.sendPrefixed(MESSAGE_CLEAR_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
        }
        if (!context.hasFlag("s")) {
            this.module.sendPrefixed(MESSAGE_CLEAR_NOTIFY, (CommandSender)target);
        }
        return true;
    }

    private boolean copyInventory(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target;
        Player source = this.getTargetOrSender(context, arguments, "player", true);
        if (source == null) {
            return false;
        }
        if (arguments.contains("target")) {
            target = this.getTargetOrSender(context, arguments, "target", true);
        } else {
            if (!context.isPlayer()) {
                context.errorPlayerOnly();
                return false;
            }
            target = context.getPlayerOrThrow();
        }
        if (target == null) {
            return false;
        }
        if (source == context.getSender() && target == context.getSender()) {
            this.module.sendPrefixed(CoreLang.COMMAND_EXECUTION_NOT_YOURSELF, context.getSender());
            return false;
        }
        Inventory sourceInventory = this.plugin.getSunNMS().getPlayerInventory(source);
        Inventory targetInventory = this.plugin.getSunNMS().getPlayerInventory(target);
        for (int slot = 0; slot < targetInventory.getSize(); ++slot) {
            targetInventory.setItem(slot, sourceInventory.getItem(slot));
        }
        if (!target.isOnline()) {
            target.saveData();
        }
        if (context.getSender() == target) {
            this.module.sendPrefixed(MESSAGE_COPY_NOTIFY, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)source)));
        } else {
            this.module.sendPrefixed(MESSAGE_COPY_FEEDBACK, context.getSender(), builder -> builder.with("%source%", () -> ((Player)source).getName()).with("%target%", () -> ((Player)target).getName()));
        }
        return true;
    }

    private boolean fillInventory(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        Material material = arguments.getMaterial("item");
        Inventory inventory = this.plugin.getSunNMS().getPlayerInventory(target);
        for (int slot = 0; slot < 36; ++slot) {
            ItemStack has = inventory.getItem(slot);
            if (has != null && !has.getType().isAir()) continue;
            inventory.setItem(slot, new ItemStack(material));
        }
        if (!target.isOnline()) {
            target.saveData();
        }
        this.module.sendPrefixed(MESSAGE_FILL_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)target)).with("%item%", () -> LangUtil.getSerializedName((Material)material)));
        return true;
    }

    private boolean openInventory(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        if (target == context.getSender()) {
            this.module.sendPrefixed(CoreLang.COMMAND_EXECUTION_NOT_YOURSELF, context.getSender());
            return false;
        }
        this.plugin.getSunNMS().openPlayerInventory(player, target);
        this.module.sendPrefixed(MESSAGE_OPEN_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
        return true;
    }

    private boolean repairInventoryItems(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        this.plugin.getSunNMS().getPlayerInventory(target).forEach(ItemStackUtils::repairItem);
        if (!target.isOnline()) {
            target.saveData();
        }
        if (context.getSender() != target) {
            this.module.sendPrefixed(MESSAGE_REPAIR_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
        }
        if (!context.hasFlag("s")) {
            this.module.sendPrefixed(MESSAGE_REPAIR_NOTIFY, (CommandSender)target);
        }
        return true;
    }
}

