/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.homes.menu;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.profile.PlayerProfiles;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.DialogRegistry;
import su.nightexpress.sunlight.module.homes.HomesModule;
import su.nightexpress.sunlight.module.homes.config.HomesLang;
import su.nightexpress.sunlight.module.homes.dialog.HomeDialogKeys;
import su.nightexpress.sunlight.module.homes.impl.Home;

public class InvitedPlayersMenu
extends AbstractObjectMenu<Home> {
    private final HomesModule module;
    private final DialogRegistry dialogRegistry;
    private ItemPopulator<UserInfo> playerPopulator;

    public InvitedPlayersMenu(@NotNull SunLightPlugin plugin, @NotNull HomesModule module, @NotNull DialogRegistry dialogRegistry) {
        super((MenuType)MenuType.GENERIC_9X4, "Invited Players", Home.class);
        this.module = module;
        this.dialogRegistry = dialogRegistry;
        this.load(plugin, FileConfig.load((String)module.getLocalUIPath(), (String)"home_invited_players.yml"));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(27, 36).toArray());
        this.addDefaultButton("return", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.IRON_DOOR).setDisplayName(TagWrappers.WHITE.wrap("Return"))).action(context -> this.module.openHomeSettings(context.getPlayer(), (Home)this.getObject((ViewerContext)context))).build()).slots(new int[]{31}).build());
        this.addDefaultButton("add_player", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.BELL).setDisplayName(TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("Add Player"))).action(context -> this.dialogRegistry.show(context.getPlayer(), HomeDialogKeys.HOME_INVITE_PLAYER_NAME, (Home)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{34}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
        int[] playerSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Players.Slots", (Object)IntStream.range(0, 27).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        this.playerPopulator = ItemPopulator.builder(UserInfo.class).actionProvider(profile -> context -> {
            if (context.getEvent().getClick() == ClickType.DROP) {
                Home home = (Home)this.getObject((ViewerContext)context);
                home.getInvitedPlayers().remove(profile);
                home.markDirty();
                context.getViewer().refresh();
            }
        }).itemProvider((context, userInfo) -> NightItem.fromType((Material)Material.PLAYER_HEAD).localized(HomesLang.UI_INVITED_PLAYERS_PLAYER).hideAllComponents().setPlayerProfile(PlayerProfiles.createProfile((UUID)userInfo.id(), (String)userInfo.name())).replace(builder -> builder.with("%player_name%", () -> ((UserInfo)userInfo).name()))).slots(playerSlots).build();
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        Home home = (Home)this.getObject(context);
        List<UserInfo> invitedPlayers = home.getInvitedPlayers().stream().sorted(Comparator.comparing(UserInfo::name)).toList();
        this.playerPopulator.populateTo(context, invitedPlayers, items);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

