/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.homes.command;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.homes.HomesModule;
import su.nightexpress.sunlight.module.homes.config.HomesLang;
import su.nightexpress.sunlight.module.homes.config.HomesPerms;
import su.nightexpress.sunlight.module.homes.impl.Home;
import su.nightexpress.sunlight.user.UserManager;

public class HomeCommonCommandProvider
extends AbstractCommandProvider {
    private static final String ARG_HOME = "home";
    private static final String COMMAND_DELETE = "delete";
    private static final String COMMAND_LIST = "list";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_TELEPORT = "teleport";
    private static final String COMMAND_VISIT = "visit";
    private static final String COMMAND_INVITE = "invite";
    private final HomesModule module;
    private final UserManager userManager;

    public HomeCommonCommandProvider(@NotNull SunLightPlugin plugin, @NotNull HomesModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_DELETE, true, new String[]{"delhome"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(HomesLang.COMMAND_DELETE_HOME_DESC)).permission(HomesPerms.COMMAND_HOMES_DELETE)).withArguments(new ArgumentNodeBuilder[]{this.homeArgument(false).optional()}).executes(this::deleteHome));
        this.registerLiteral(COMMAND_LIST, true, new String[]{"homelist"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(HomesLang.COMMAND_HOME_LIST_DESC)).permission(HomesPerms.COMMAND_HOMES_LIST)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(HomesPerms.COMMAND_HOMES_LIST_OTHERS)}).executes(this::listHomes));
        this.registerLiteral(COMMAND_SET, true, new String[]{"sethome"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(HomesLang.COMMAND_SET_HOME_DESC)).permission(HomesPerms.COMMAND_HOMES_SET)).withArguments(new ArgumentNodeBuilder[]{Arguments.string((String)"name").optional().localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME).suggestions((reader, context) -> this.module.getHomes(context.getPlayerOrThrow()).stream().map(Home::getId).toList())}).executes(this::setHome));
        this.registerLiteral(COMMAND_TELEPORT, true, new String[]{ARG_HOME}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(HomesLang.COMMAND_TELEPORT_HOME_DESC)).permission(HomesPerms.COMMAND_HOMES_TELEPORT)).withArguments(new ArgumentNodeBuilder[]{this.homeArgument(false).optional()}).executes(this::teleportToHome));
        this.registerLiteral(COMMAND_VISIT, true, new String[]{"visithome"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(HomesLang.COMMAND_VISIT_HOME_DESC)).permission(HomesPerms.COMMAND_HOMES_VISIT)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player").suggestions((reader, context) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return Collections.emptyList();
            }
            return this.module.getRepository().getAll(home -> home.canVisit(player)).stream().map(Home::getOwner).map(UserInfo::name).distinct().toList();
        }), this.homeArgument(true)}).executes(this::visitHome));
        this.registerLiteral(COMMAND_INVITE, false, new String[]{"homeinvite"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(HomesLang.COMMAND_HOME_INVITE_DESC)).permission(HomesPerms.COMMAND_HOMES_INVITE)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), this.homeArgument(false)}).executes(this::inviteHome));
        this.registerRoot("homes", true, new String[]{"homes"}, (Map<String, String> map) -> {
            map.put(COMMAND_DELETE, COMMAND_DELETE);
            map.put(COMMAND_LIST, COMMAND_LIST);
            map.put(COMMAND_SET, COMMAND_SET);
            map.put(COMMAND_TELEPORT, COMMAND_TELEPORT);
            map.put(COMMAND_VISIT, COMMAND_VISIT);
            map.put(COMMAND_INVITE, COMMAND_INVITE);
        }, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(HomesLang.COMMAND_HOMES_ROOT_DESC)).permission(HomesPerms.COMMAND_HOMES_ROOT));
    }

    @NotNull
    private ArgumentNodeBuilder<Home> homeArgument(boolean ofPlayer) {
        return Commands.argument((String)ARG_HOME, (context, string) -> Optional.of(ofPlayer ? context.getArguments().getString("player") : context.getSender().getName()).map(name -> this.userManager.getRepository().getAssociatedId(name)).map(playerId -> this.module.getHome((UUID)playerId, string)).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)HomesLang.COMMAND_SYNTAX_INVALID_HOME))).localized(HomesLang.COMMAND_ARGUMENT_NAME_HOME).suggestions((reader, context) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return Collections.emptyList();
            }
            String ownerName = ofPlayer ? context.getArguments().getString("player") : player.getName();
            UUID ownerId = this.userManager.getRepository().getAssociatedId(ownerName);
            if (ownerId == null) {
                return Collections.emptyList();
            }
            return this.module.getUserRepository(ownerId).getAll(home -> home.canVisit(player)).stream().map(Home::getId).toList();
        });
    }

    @Nullable
    private Home getHomeOrDefault(@NotNull Player player, @NotNull ParsedArguments arguments, @NotNull CommandContext context) {
        if (arguments.contains(ARG_HOME)) {
            return (Home)arguments.get(ARG_HOME, Home.class);
        }
        Home home = this.module.getFavoriteHome(player);
        if (home == null) {
            this.module.sendPrefixed(HomesLang.ERROR_NO_HOMES, context.getSender());
            return null;
        }
        return home;
    }

    private boolean deleteHome(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Home home = this.getHomeOrDefault(player, arguments, context);
        if (home == null) {
            return false;
        }
        return this.module.removeHome(player, home);
    }

    private boolean listHomes(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        String targetName = arguments.getString("player", player.getName());
        UUID targetId = this.userManager.getRepository().getAssociatedId(targetName);
        if (targetId == null) {
            context.errorBadPlayer();
            return false;
        }
        return this.module.openHomes(player, targetId);
    }

    private boolean setHome(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        String name = arguments.getString("name", "default");
        return this.module.setHome(player, name, false);
    }

    private boolean teleportToHome(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Home home = this.getHomeOrDefault(player, arguments, context);
        if (home == null) {
            return false;
        }
        return this.module.teleportToHome(player, home);
    }

    private boolean visitHome(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        String ownerName = arguments.getString("player");
        UUID ownerId = this.userManager.getRepository().getAssociatedId(ownerName);
        if (ownerId == null) {
            context.errorBadPlayer();
            return false;
        }
        Home home = (Home)arguments.get(ARG_HOME, Home.class);
        return this.module.visitHome(player, home);
    }

    private boolean inviteHome(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Home home = this.getHomeOrDefault(player, arguments, context);
        if (home == null) {
            return false;
        }
        String targetName = arguments.getString("player");
        UUID targetId = this.userManager.getRepository().getAssociatedId(targetName);
        if (targetId == null) {
            context.errorBadPlayer();
            return false;
        }
        return this.module.inviteToHome(player, home, new UserInfo(targetId, targetName));
    }
}

