/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.godmode.command;

import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandArguments;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.godmode.GodModule;
import su.nightexpress.sunlight.module.godmode.config.GodLang;
import su.nightexpress.sunlight.module.godmode.config.GodPerms;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserProperty;

public class GodCommands
extends AbstractCommandProvider {
    private static final String COMMAND_OFF = "off";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_TOGGLE = "toggle";
    private final GodModule module;

    public GodCommands(@NotNull SunLightPlugin plugin, @NotNull GodModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_OFF, false, new String[]{"godoff"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.OFF));
        this.registerLiteral(COMMAND_ON, false, new String[]{"godon"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.ON));
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"god"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.TOGGLE));
        this.registerRoot("god", true, new String[]{"godmode"}, Map.of(COMMAND_OFF, COMMAND_OFF, COMMAND_ON, COMMAND_ON, COMMAND_TOGGLE, COMMAND_TOGGLE), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description("TODO")).permission("TODO"));
    }

    private void buildCommand(@NotNull LiteralNodeBuilder builder, @NotNull ToggleMode mode) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(GodLang.COMMAND_GOD_DESC)).permission(GodPerms.COMMAND_GOD)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.toggleMode("mode").optional(), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(GodPerms.COMMAND_GOD_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleGod(context, arguments, mode));
    }

    private boolean toggleGod(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        Player target = this.getTargetOrSender(context, arguments, "player", false);
        if (target == null) {
            return false;
        }
        SunUser user = (SunUser)this.plugin.getUserManager().getOrFetch(target);
        UserProperty<Boolean> setting = GodModule.GOD_MODE;
        boolean state = mode.apply(user.getProperty(setting));
        user.setProperty(setting, state);
        user.markDirty();
        if (state && !this.module.isAllowedWorld(target)) {
            GodLang.NOTIFY_BAD_WORLD.message().send((CommandSender)target);
        }
        if (context.getSender() != target) {
            context.send(GodLang.COMMAND_GOD_TOGGLE_TARGET, replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)).replace(SLPlaceholders.forPlayer((Player)target)));
        }
        if (!context.hasFlag("s")) {
            GodLang.COMMAND_GOD_TOGGLE_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
        }
        return true;
    }
}

