/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.godmode.command;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.godmode.GodModule;
import su.nightexpress.sunlight.module.godmode.config.GodLang;
import su.nightexpress.sunlight.module.godmode.config.GodPerms;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.user.property.UserProperty;

public class FoodGodCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_OFF = "off";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_TOGGLE = "toggle";
    private final GodModule module;
    private final UserManager userManager;

    public FoodGodCommandProvider(@NotNull SunLightPlugin plugin, @NotNull GodModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_OFF, false, new String[]{"foodgod-off"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.OFF));
        this.registerLiteral(COMMAND_ON, false, new String[]{"foodgod-on"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.ON));
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"foodgod"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.TOGGLE));
    }

    private void buildCommand(@NotNull LiteralNodeBuilder builder, @NotNull ToggleMode mode) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(GodLang.COMMAND_FOOD_GOD_DESC)).permission(GodPerms.COMMAND_FOOD_GOD)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(GodPerms.COMMAND_FOOD_GOD_OTHERS)}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleFoodGod(context, arguments, mode));
    }

    private boolean toggleFoodGod(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        this.loadUserWithPlayerDataAsync(context, arguments, this.userManager, (user, target) -> {
            UserProperty<Boolean> setting = GodModule.FOOD_GOD;
            boolean state = mode.apply(user.getProperty(setting));
            user.setProperty(setting, state);
            user.markDirty();
            if (context.getSender() != target) {
                context.send(GodLang.COMMAND_FOOD_GOD_TARGET, replacer -> replacer.replace(SLPlaceholders.forPlayer((Player)target)).replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
            }
            if (!context.hasFlag("s")) {
                GodLang.COMMAND_FOOD_GOD_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
            }
        });
        return true;
    }
}

