/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.godmode;

import java.util.Set;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.godmode.GodListener;
import su.nightexpress.sunlight.module.godmode.command.GodCommands;
import su.nightexpress.sunlight.module.godmode.config.GodConfig;
import su.nightexpress.sunlight.module.godmode.config.GodLang;
import su.nightexpress.sunlight.module.godmode.config.GodPerms;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserProperty;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class GodModule
extends Module {
    public static final UserProperty<Boolean> FOOD_GOD = UserProperty.create("food_god", Boolean.class, false, true);
    public static final UserProperty<Boolean> GOD_MODE = UserProperty.create("god_mode", Boolean.class, false, false);

    public GodModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        config.initializeOptions(GodConfig.class);
        ((SunLightPlugin)this.plugin).injectLang(GodLang.class);
        UserPropertyRegistry.register(FOOD_GOD);
        UserPropertyRegistry.register(GOD_MODE);
        this.addListener((SimpeListener)new GodListener((SunLightPlugin)this.plugin, this));
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(GodPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("god", new GodCommands((SunLightPlugin)this.plugin, this));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    public boolean hasAnyGod(@NotNull Player player) {
        return this.hasClassicGod(player) || this.hasFoodGod(player);
    }

    public boolean hasClassicGod(@NotNull Player player) {
        SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
        return user.getProperty(GOD_MODE);
    }

    public boolean hasFoodGod(@NotNull Player player) {
        SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
        return user.getProperty(FOOD_GOD);
    }

    public boolean isAllowedWorld(@NotNull World world) {
        return !((Set)GodConfig.DISABLED_WORLDS.get()).contains(world.getName());
    }

    public boolean isAllowedWorld(@NotNull Player player) {
        if (player.hasPermission(GodPerms.BYPASS_WORLDS)) {
            return true;
        }
        return this.isAllowedWorld(player.getWorld());
    }
}

