/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.godmode;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.godmode.GodModule;
import su.nightexpress.sunlight.module.godmode.config.GodConfig;
import su.nightexpress.sunlight.module.godmode.config.GodLang;

public class GodListener
extends AbstractListener<SunLightPlugin> {
    private final GodModule module;

    public GodListener(@NotNull SunLightPlugin plugin, @NotNull GodModule module) {
        super((NightCorePlugin)plugin);
        this.module = module;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (!this.module.isAllowedWorld(player) && this.module.hasAnyGod(player)) {
            GodLang.NOTIFY_BAD_WORLD.message().send((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDamageIncoming(EntityDamageEvent event) {
        Entity victim = event.getEntity();
        if (!(victim instanceof Player)) {
            return;
        }
        Player player = (Player)victim;
        if (!this.module.isAllowedWorld(player)) {
            return;
        }
        if (this.module.hasClassicGod(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDamageOutgoing(EntityDamageByEntityEvent event) {
        Projectile projectile;
        ProjectileSource projectileSource;
        Entity damager = event.getDamager();
        if (damager instanceof Projectile && (projectileSource = (projectile = (Projectile)damager).getShooter()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)projectileSource;
            damager = living;
        }
        if (!(damager instanceof Player)) {
            return;
        }
        Player player = (Player)damager;
        if (!this.module.isAllowedWorld(player)) {
            return;
        }
        if (!this.module.hasClassicGod(player)) {
            return;
        }
        Entity victim = event.getEntity();
        if (victim instanceof Player && ((Boolean)GodConfig.OUT_DAMAGE_PLAYERS.get()).booleanValue()) {
            return;
        }
        if (((Boolean)GodConfig.OUT_DAMAGE_MOBS.get()).booleanValue()) {
            return;
        }
        event.setCancelled(true);
        GodLang.NOTIFY_DISABLED_DAMAGE.message().send((CommandSender)player);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFoodChange(FoodLevelChangeEvent event) {
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.module.hasFoodGod(player)) {
            return;
        }
        event.setCancelled(true);
    }
}

