/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras.listener;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.GlassPane;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.random.Rnd;
import su.nightexpress.sunlight.SunLightPlugin;

public class PhysicsExplosionListener
extends AbstractListener<SunLightPlugin> {
    private static final Set<Material> ILLEGAL_ITEMS = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.TNT, Material.SPAWNER, Material.BEDROCK, Material.BARRIER, Material.FARMLAND, Material.BUDDING_AMETHYST});
    private final NamespacedKey physx;

    public PhysicsExplosionListener(@NotNull SunLightPlugin plugin) {
        super((NightCorePlugin)plugin);
        this.physx = new NamespacedKey((Plugin)plugin, "physical_block");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        ExplosionResult result = event.getExplosionResult();
        if (result != ExplosionResult.DESTROY && result != ExplosionResult.DESTROY_WITH_DECAY) {
            return;
        }
        this.create(event.blockList(), event.getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        ExplosionResult result = event.getExplosionResult();
        if (result != ExplosionResult.DESTROY && result != ExplosionResult.DESTROY_WITH_DECAY) {
            return;
        }
        this.create(event.blockList(), event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPhysLand(EntityChangeBlockEvent event) {
        FallingBlock fallingBlock;
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock && PDCUtil.getBoolean((PersistentDataHolder)(fallingBlock = (FallingBlock)entity), (NamespacedKey)this.physx).isPresent()) {
            ((SunLightPlugin)this.plugin).getSunNMS().dropFallingContent(fallingBlock);
            event.setCancelled(true);
        }
    }

    private void create(@NotNull List<Block> list, @NotNull Location from) {
        list.removeIf(block -> {
            Material type = block.getType();
            if (type.isInteractable()) {
                return false;
            }
            BlockData blockData = block.getBlockData();
            if (!type.isSolid() || blockData instanceof Leaves || blockData instanceof GlassPane) {
                return false;
            }
            if (ILLEGAL_ITEMS.contains(type)) {
                return false;
            }
            BlockData fallData = blockData;
            if (type == Material.GRASS_BLOCK || type == Material.MYCELIUM || type == Material.DIRT_PATH) {
                fallData = Material.DIRT.createBlockData();
            }
            FallingBlock fall = block.getWorld().spawnFallingBlock(block.getLocation(), fallData);
            fall.setDropItem(true);
            fall.setCancelDrop(false);
            fall.setFallDistance(0.0f);
            PDCUtil.set((PersistentDataHolder)fall, (NamespacedKey)this.physx, (boolean)true);
            Vector vector = LocationUtil.getDirection((Location)from, (Location)fall.getLocation()).multiply(0.6);
            vector.setY(vector.getY() + 0.3 + Rnd.getDouble((double)0.0, (double)2.0) / 4.5);
            fall.setVelocity(vector);
            block.setType(Material.AIR);
            return false;
        });
    }
}

