/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras.chestsort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.extras.ExtrasModule;
import su.nightexpress.sunlight.module.extras.chestsort.SortListener;
import su.nightexpress.sunlight.module.extras.config.ExtrasConfig;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserProperty;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class SortManager
extends AbstractManager<SunLightPlugin> {
    public static final UserProperty<Boolean> SETTING_CHEST_SORT = UserProperty.create("chest_sort", Boolean.class, false, true);

    public SortManager(@NotNull SunLightPlugin plugin, @NotNull ExtrasModule module) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.loadCommands();
        UserPropertyRegistry.register(SETTING_CHEST_SORT);
        this.addListener((SimpeListener)new SortListener((SunLightPlugin)this.plugin, this));
    }

    protected void onShutdown() {
    }

    private void loadCommands() {
    }

    public static boolean isChestSortEnabled(@NotNull SunUser user) {
        return user.getProperty(SETTING_CHEST_SORT);
    }

    @NotNull
    private String getItemSortedId(@NotNull ItemStack item) {
        StringBuilder rules = new StringBuilder();
        ((List)ExtrasConfig.CHEST_SORT_RULES.get()).forEach(rule -> rules.append(rule.getRule(item)));
        return rules.toString();
    }

    public void sortInventory(@NotNull Inventory inventory) {
        List<ItemStack> sorted = Arrays.stream(inventory.getContents()).filter(item -> item != null && !item.getType().isAir()).sorted(Comparator.comparing(this::getItemSortedId)).toList();
        inventory.clear();
        for (int slot = 0; slot < sorted.size(); ++slot) {
            inventory.setItem(slot, sorted.get(slot));
        }
    }
}

