/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras.chestsort;

import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.extras.chestsort.SortManager;
import su.nightexpress.sunlight.module.extras.config.ExtrasLang;
import su.nightexpress.sunlight.module.extras.config.ExtrasPerms;
import su.nightexpress.sunlight.user.SunUser;

public class SortCommand
extends AbstractCommandProvider {
    private static final String COMMAND_OFF = "off";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_TOGGLE = "toggle";
    private final SortManager manager;

    public SortCommand(@NotNull SunLightPlugin plugin, @NotNull SortManager manager) {
        super(plugin);
        this.manager = manager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("chestsort", true, new String[]{"chestsort"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ExtrasLang.COMMAND_CHEST_SORT_DESC)).permission(ExtrasPerms.COMMAND_CHEST_SORT)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(ExtrasPerms.COMMAND_CHEST_SORT_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleSorting(context, arguments, ToggleMode.TOGGLE)));
        this.registerRoot("mode", true, new String[]{"sortmode"}, Map.of(COMMAND_OFF, COMMAND_OFF, COMMAND_ON, COMMAND_ON, COMMAND_TOGGLE, COMMAND_TOGGLE), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description("TODO")).permission("TODO"));
    }

    private boolean toggleSorting(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        SunUser user = (SunUser)this.plugin.getUserManager().getOrFetch(target);
        boolean state = mode.apply(SortManager.isChestSortEnabled(user));
        user.setProperty(SortManager.SETTING_CHEST_SORT, state);
        user.markDirty();
        if (context.getSender() != target) {
            context.send(ExtrasLang.COMMAND_CHEST_SORT_TARGET, replacer -> replacer.replace(SLPlaceholders.forPlayer((Player)target)).replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
        }
        if (!context.hasFlag("s")) {
            ExtrasLang.COMMAND_CHEST_SORT_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
        }
        return true;
    }
}

