/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.extras.chairs;

import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.extras.chairs.ChairsManager;
import su.nightexpress.sunlight.module.extras.config.ExtrasLang;
import su.nightexpress.sunlight.module.extras.config.ExtrasPerms;
import su.nightexpress.sunlight.user.SunUser;

public class ChairsCommands
extends AbstractCommandProvider {
    public static final String NODE_TOGGLE = "chairs_toggle";
    public static final String NODE_SIT = "chairs_sit";
    private static final String COMMAND_OFF = "off";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_TOGGLE = "toggle";
    private final ChairsManager manager;

    public ChairsCommands(@NotNull SunLightPlugin plugin, @NotNull ChairsManager manager) {
        super(plugin);
        this.manager = manager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("chairs", true, new String[]{"chairs"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ExtrasLang.COMMAND_CHAIRS_DESC)).permission(ExtrasPerms.COMMAND_CHAIRS)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(ExtrasPerms.COMMAND_CHAIRS_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleChairs(context, arguments, ToggleMode.TOGGLE)));
        this.registerLiteral("sit", true, new String[]{"sit"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ExtrasLang.COMMAND_SIT_DESC)).permission(ExtrasPerms.COMMAND_SIT)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(ExtrasPerms.COMMAND_SIT_OTHERS)}).withFlags(new String[]{"s"}).executes(this::sit));
        this.registerRoot("mode", false, new String[]{"chairsmode"}, Map.of(COMMAND_OFF, COMMAND_OFF, COMMAND_ON, COMMAND_ON, COMMAND_TOGGLE, COMMAND_TOGGLE), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description("TODO")).permission("TODO"));
    }

    private boolean toggleChairs(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        SunUser user = (SunUser)this.plugin.getUserManager().getOrFetch(target);
        boolean state = mode.apply(ChairsManager.isChairsEnabled(user));
        user.setProperty(ChairsManager.SETTING_CHAIRS, state);
        user.markDirty();
        if (context.getSender() != target) {
            context.send(ExtrasLang.COMMAND_CHAIRS_TARGET, replacer -> replacer.replace(SLPlaceholders.forPlayer((Player)target)).replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
        }
        if (!context.hasFlag("s")) {
            ExtrasLang.COMMAND_CHAIRS_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
        }
        return true;
    }

    private boolean sit(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null || this.manager.isSit(target)) {
            return false;
        }
        Block block = target.getLocation().getBlock();
        if (block.isEmpty() || !block.getType().isSolid()) {
            block = block.getRelative(BlockFace.DOWN);
        }
        if (block.isEmpty() || !block.getType().isSolid()) {
            return false;
        }
        this.manager.sitPlayer(target, block);
        return true;
    }
}

