/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.teleport.TeleportFlag;
import su.nightexpress.sunlight.teleport.TeleportFlags;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.teleport.TeleportResult;
import su.nightexpress.sunlight.user.UserManager;

public class TeleportCommandsProvider
extends AbstractCommandProvider {
    private static final String COMMAND_LOCATION = "tppos";
    private static final String COMMAND_SEND = "tpplayer";
    private static final String COMMAND_SUMMON = "tphere";
    private static final String COMMAND_GO_TO = "goto";
    private static final String COMMAND_TOP = "tptop";
    private static final Permission PERMISSION_LOCATION = EssentialPerms.COMMAND.permission("teleport.location");
    private static final Permission PERMISSION_LOCATION_OTHERS = EssentialPerms.COMMAND.permission("teleport.location.others");
    private static final Permission PERMISSION_SUMMON = EssentialPerms.COMMAND.permission("teleport.summon");
    private static final Permission PERMISSION_TO = EssentialPerms.COMMAND.permission("teleport.to");
    private static final Permission PERMISSION_SEND = EssentialPerms.COMMAND.permission("teleport.send");
    private static final Permission PERMISSION_TOP = EssentialPerms.COMMAND.permission("teleport.top");
    private static final Permission PERMISSION_TOP_OTHERS = EssentialPerms.COMMAND.permission("teleport.top.others");
    private static final TextLocale DESCRIPTION_LOCATION = LangEntry.builder((String)"Command.Teleport.Location.Desc").text("Teleport to specific position.");
    private static final TextLocale DESCRIPTION_SUMMON = LangEntry.builder((String)"Command.Teleport.Summon.Desc").text("Teleport player to your location.");
    private static final TextLocale DESCRIPTION_TO = LangEntry.builder((String)"Command.Teleport.To.Desc").text("Teleport to a player's location.");
    private static final TextLocale DESCRIPTION_SEND = LangEntry.builder((String)"Command.Teleport.Send.Desc").text("Teleport one player to another.");
    private static final TextLocale DESCRIPTION_TOP = LangEntry.builder((String)"Command.Teleport.Top.Desc").text("Teleport to the highest block above you.");
    private static final MessageLocale MESSAGE_COORDS_FEEDBACK = LangEntry.builder((String)"Command.Teleport.Location.Done.Target").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have teleported " + TagWrappers.WHITE.wrap("%player_display_name%") + " teleported to " + TagWrappers.RED.wrap("%location_x%") + " " + TagWrappers.GREEN.wrap("%location_y%") + " " + TagWrappers.BLUE.wrap("%location_z%") + " @ " + TagWrappers.WHITE.wrap("%location_world%") + ".")});
    private static final MessageLocale MESSAGE_COORDS_NOTIFY = LangEntry.builder((String)"Command.Teleport.Location.Done.Notify").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have been teleported to " + TagWrappers.RED.wrap("%location_x%") + " " + TagWrappers.GREEN.wrap("%location_y%") + " " + TagWrappers.BLUE.wrap("%location_z%") + " @ " + TagWrappers.WHITE.wrap("%location_world%") + ".")});
    private static final MessageLocale MESSAGE_SUMMON_FEEDBACK = LangEntry.builder((String)"Command.Teleport.Summon.Target").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have summonned " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final MessageLocale MESSAGE_SUMMON_NOTIFY = LangEntry.builder((String)"Command.Teleport.Summon.Notify").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have been summoned by " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final MessageLocale MESSAGE_TO_DONE = LangEntry.builder((String)"Command.Teleport.To.Done").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have been teleported to " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final MessageLocale MESSAGE_MOVE_FEEDBACK = LangEntry.builder((String)"Command.Teleport.Send.Target").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have teleported " + TagWrappers.RED.wrap("%source%") + " to " + TagWrappers.BLUE.wrap("%target%") + ".")});
    private static final MessageLocale MESSAGE_MOVE_NOTIFY = LangEntry.builder((String)"Command.Teleport.Send.Notify").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have been teleported to " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final MessageLocale MESSAGE_SURFACE_FEEDBACK = LangEntry.builder((String)"Command.Teleport.Top.Target").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have teleported " + TagWrappers.WHITE.wrap("%player_display_name%") + " to the surface.")});
    private static final MessageLocale MESSAGE_SURFACE_NOTIFY = LangEntry.builder((String)"Command.Teleport.Top.Notify").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have been teleported to the surface.")});
    private final EssentialModule module;
    private final UserManager userManager;
    private final TeleportManager teleportManager;

    public TeleportCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager, @NotNull TeleportManager teleportManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
        this.teleportManager = teleportManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_LOCATION, true, new String[]{"coords", COMMAND_LOCATION, "tploc"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_LOCATION)).permission(PERMISSION_LOCATION)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"x").localized(Lang.COMMAND_ARGUMENT_NAME_X).suggestions((reader, context) -> this.getTabLocation(context, Block::getX)), Arguments.integer((String)"y").localized(Lang.COMMAND_ARGUMENT_NAME_Y).suggestions((reader, context) -> this.getTabLocation(context, Block::getY)), Arguments.integer((String)"z").localized(Lang.COMMAND_ARGUMENT_NAME_Z).suggestions((reader, context) -> this.getTabLocation(context, Block::getZ)), Arguments.world((String)"world"), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_LOCATION_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::teleportToCoords));
        this.registerLiteral(COMMAND_SEND, true, new String[]{"move", COMMAND_SEND}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_SEND)).permission(PERMISSION_SEND)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.playerName((String)"target").localized(Lang.COMMAND_ARGUMENT_NAME_TARGET)}).withFlags(new String[]{"s"}).executes(this::movePlayerToOther));
        this.registerLiteral(COMMAND_SUMMON, true, new String[]{"bring", COMMAND_SUMMON, "movehere"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION_SUMMON)).permission(PERMISSION_SUMMON)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player")}).withFlags(new String[]{"s"}).executes(this::summonPlayer));
        this.registerLiteral(COMMAND_GO_TO, true, new String[]{COMMAND_GO_TO, "tpto", "moveto"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION_TO)).permission(PERMISSION_TO)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player")}).executes(this::teleportToPlayer));
        this.registerLiteral(COMMAND_TOP, true, new String[]{"surface", COMMAND_TOP, "movetop"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_TOP.text())).permission(PERMISSION_TOP)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_TOP_OTHERS)}).withFlags(new String[]{"s"}).executes(this::teleportToTop));
    }

    @NotNull
    private List<String> getTabLocation(@NotNull CommandContext context, @NotNull Function<Block, Integer> function) {
        Player player = context.getPlayer();
        if (player == null) {
            return Collections.emptyList();
        }
        Block block = player.getTargetBlock(null, 100);
        return Lists.newList((Object[])new String[]{NumberUtil.format((double)function.apply(block).intValue())});
    }

    private boolean teleportToCoords(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            World world = arguments.getWorld("world", target.getWorld());
            int x = arguments.getInt("x");
            int y = arguments.getInt("y");
            int z = arguments.getInt("z");
            Block block = world.getBlockAt(x, y, z);
            Location location = block.getRelative(BlockFace.UP).getLocation();
            TeleportResult result = this.teleportManager.move((Player)target, location, TeleportFlags.of(TeleportFlag.PREVENT_CLIPPING, TeleportFlag.KEEP_DIRECTION));
            if (result != TeleportResult.SUCCESS) {
                Lang.sendTeleportFailure(context.getSender(), target, result);
                return;
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_COORDS_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with(CommonPlaceholders.LOCATION.resolver((Object)location)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_COORDS_NOTIFY, (CommandSender)target, replacer -> replacer.with(CommonPlaceholders.LOCATION.resolver((Object)location)));
            }
        });
    }

    private boolean movePlayerToOther(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = this.getTargetOrSender(context, arguments, "player", true);
        Player target = this.getTargetOrSender(context, arguments, "target", true);
        if (player == null || target == null) {
            return false;
        }
        TeleportResult result = this.teleportManager.move(player, target.getLocation(), TeleportFlags.of(TeleportFlag.KEEP_DIRECTION, TeleportFlag.LOOK_FOR_SURFACE));
        if (result != TeleportResult.SUCCESS) {
            Lang.sendTeleportFailure(context.getSender(), player, result);
            return false;
        }
        if (player != context.getSender()) {
            this.module.sendPrefixed(MESSAGE_MOVE_FEEDBACK, context.getSender(), replacer -> replacer.with("%source%", () -> ((Player)player).getName()).with("%target%", () -> ((Player)target).getName()));
        }
        if (!context.hasFlag("s")) {
            this.module.sendPrefixed(MESSAGE_MOVE_NOTIFY, (CommandSender)player, replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
        }
        return true;
    }

    private boolean summonPlayer(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player executor = context.getPlayerOrThrow();
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            if (target == executor) {
                this.module.sendPrefixed(CoreLang.COMMAND_EXECUTION_NOT_YOURSELF, context.getSender());
                return;
            }
            TeleportResult result = this.teleportManager.move((Player)target, executor.getLocation(), TeleportFlags.of(TeleportFlag.KEEP_DIRECTION, TeleportFlag.LOOK_FOR_SURFACE));
            if (result != TeleportResult.SUCCESS) {
                Lang.sendTeleportFailure(context.getSender(), target, result);
                return;
            }
            this.module.sendPrefixed(MESSAGE_SUMMON_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_SUMMON_NOTIFY, (CommandSender)target, replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver((Object)executor)));
            }
        });
    }

    private boolean teleportToPlayer(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            if (target == player) {
                this.module.sendPrefixed(CoreLang.COMMAND_EXECUTION_NOT_YOURSELF, context.getSender());
                return;
            }
            TeleportResult result = this.teleportManager.move(player, target.getLocation(), TeleportFlags.of(TeleportFlag.LOOK_FOR_SURFACE));
            if (result != TeleportResult.SUCCESS) {
                Lang.sendTeleportFailure(context.getSender(), player, result);
                return;
            }
            this.module.sendPrefixed(MESSAGE_TO_DONE, (CommandSender)player, replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
        });
    }

    private boolean teleportToTop(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            Block block = target.getWorld().getHighestBlockAt(target.getLocation()).getRelative(BlockFace.UP);
            Location location = block.getLocation();
            TeleportResult result = this.teleportManager.move((Player)target, location, TeleportFlags.of(TeleportFlag.KEEP_DIRECTION, TeleportFlag.PREVENT_CLIPPING, TeleportFlag.CENTERED));
            if (result != TeleportResult.SUCCESS) {
                Lang.sendTeleportFailure(context.getSender(), target, result);
                return;
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_SURFACE_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_SURFACE_NOTIFY, (CommandSender)target);
            }
        });
    }
}

