/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;

public class StaffCommandProvider
extends AbstractCommandProvider {
    private static final Permission STAFF = EssentialPerms.COMMAND.permission("staff");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Staff.Desc").text("Show online staff.");
    private static final MessageLocale MESSAGE_NO_STAFF_ONLINE = LangEntry.builder((String)"Command.Staff.Empty").chatMessage(TagWrappers.GRAY.wrap("There is no staff online."));
    private final EssentialModule module;
    private final EssentialSettings settings;

    public StaffCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings) {
        super(plugin);
        this.module = module;
        this.settings = settings;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("staff", true, new String[]{"staff"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(STAFF)).executes(this::showStaff));
    }

    @NotNull
    private String formatEntry(@NotNull Player player) {
        return (String)SLPlaceholders.forPlayerWithPAPI((Player)player).apply((String)this.settings.staffEntryFormat.get());
    }

    private boolean showStaff(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player executor = context.getPlayer();
        HashSet staffs = new HashSet();
        Players.getOnline().forEach(other -> {
            if (executor != null && !executor.canSee(other)) {
                return;
            }
            Set playerRanks = Players.getInheritanceGroups((Player)other);
            if (playerRanks.stream().anyMatch(((List)this.settings.staffRanks.get())::contains)) {
                staffs.add(other);
            }
        });
        if (staffs.isEmpty()) {
            this.module.sendPrefixed(MESSAGE_NO_STAFF_ONLINE, context.getSender());
            return false;
        }
        String entries = staffs.stream().sorted(Comparator.comparing(Player::getName)).map(this::formatEntry).collect(Collectors.joining(TagWrappers.BR));
        String text = String.join((CharSequence)"\n", Replacer.create().replace("%entry%", (Object)entries).replace("%amount%", () -> String.valueOf(staffs.size())).apply((List)this.settings.staffFormat.get()));
        Players.sendMessage((CommandSender)context.getSender(), (String)text);
        return true;
    }
}

