/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.stream.IntStream;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.user.UserManager;

public class SpeedCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("speed");
    private static final Permission PERMISSION_OTHERS = EssentialPerms.COMMAND.permission("speed.others");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Speed.Desc").text("Change walk speed.");
    private static final MessageLocale MESSAGE_SET_SPEED_NOTIFY = LangEntry.builder((String)"Command.Speed.Done.Notify").chatMessage(Sound.ITEM_FIRECHARGE_USE, new String[]{TagWrappers.GRAY.wrap("Your walk speed has been changed to " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + ".")});
    private static final MessageLocale MESSAGE_SET_SPEED_FEEDBACK = LangEntry.builder((String)"Command.Speed.Done.Target").chatMessage(Sound.ITEM_FIRECHARGE_USE, new String[]{TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s walk speed to " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + ".")});
    private static final float DEF_SPEED = 0.2f;
    private static final float MAX_SPEED = 1.0f;
    private static final int SPEEDS_AMOUNT = 10;
    private final EssentialModule module;
    private final UserManager userManager;

    public SpeedCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("speed", true, new String[]{"speed", "walkspeed"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"value", (int)1).suggestions((reader, tabContext) -> IntStream.range(1, 11).boxed().map(String::valueOf).toList()), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::changeSpeed));
    }

    private boolean changeSpeed(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            int speed = Math.clamp((long)arguments.getInt("value"), 1, 10);
            float realSpeed = 0.2f + 0.8f * (float)(speed - 1) / 9.0f;
            target.setWalkSpeed(realSpeed);
            if (!target.isOnline()) {
                target.saveData();
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_SET_SPEED_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%amount%", () -> String.valueOf(speed)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_SET_SPEED_NOTIFY, (CommandSender)target, replacer -> replacer.with("%amount%", () -> String.valueOf(speed)));
            }
        });
    }
}

