/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandArguments;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialPerms;

@Deprecated
public class SpawnMobCommandProvider
extends AbstractCommandProvider {
    public static final Permission PERMISSION = EssentialPerms.COMMAND.permission("spawnmob");
    public static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Mob.Spawn.Desc").text("Spawn a mob.");
    public static final MessageLocale MESSAGE_SPAWNED_FEEDBACK = LangEntry.builder((String)"Command.Mob.Spawn.Done").chatMessage(TagWrappers.GRAY.wrap("You have spawned " + TagWrappers.SOFT_YELLOW.wrap("%amount%x %type%") + "."));
    private int spawnLimit;

    public SpawnMobCommandProvider(@NotNull SunLightPlugin plugin) {
        super(plugin);
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
        this.spawnLimit = Math.max(1, (Integer)config.get(ConfigTypes.INT, path + ".SpawnLimit", (Object)10, new String[]{"Sets max. allowed mobs amount value per command execution."}));
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("spawnmob", true, new String[]{"spawnmob"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.entityType(EntityType::isSpawnable), Arguments.integer((String)"amount", (int)1).optional().localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT.text()).suggestions((reader, tabContext) -> IntStream.range(1, this.spawnLimit).boxed().map(String::valueOf).toList())}).executes(this::spawnMob));
    }

    private boolean spawnMob(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        EntityType entityType = (EntityType)arguments.get("type", EntityType.class);
        int amount = Math.min(this.spawnLimit, arguments.getInt("amount", 1));
        Location location = LocationUtil.setCenter2D((Location)player.getTargetBlock(null, 100).getRelative(BlockFace.UP).getLocation());
        for (int count = 0; count < amount; ++count) {
            player.getWorld().spawnEntity(location, entityType);
        }
        context.send(MESSAGE_SPAWNED_FEEDBACK, replacer -> replacer.replace("%amount%", (Object)String.valueOf(amount)).replace("%type%", (Object)LangUtil.getSerializedName((EntityType)entityType)));
        return true;
    }
}

