/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;

public class SmiteCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("smite");
    private static final Permission PERMISSION_OTHERS = EssentialPerms.COMMAND.permission("smite.others");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Smite.Desc").text("Smite player with lightning.");
    private static final MessageLocale COMMAND_SMITE_TARGET = LangEntry.builder((String)"Command.Smite.Target").chatMessage(TagWrappers.GRAY.wrap("You have smited " + TagWrappers.SOFT_YELLOW.wrap("%player_name%") + "!"));
    private static final MessageLocale COMMAND_SMITE_NOTIFY = LangEntry.builder((String)"Command.Smite.Notify").chatMessage(TagWrappers.GRAY.wrap("You have been smited!"));
    private final EssentialModule module;

    public SmiteCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("smite", true, new String[]{"smite"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.player((String)"player").permission(PERMISSION_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::execute));
    }

    private boolean execute(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.forOnlinePlayerOrSender(context, arguments, target -> {
            target.getWorld().strikeLightning(target.getLocation());
            if (context.getSender() != target) {
                this.module.sendPrefixed(COMMAND_SMITE_TARGET, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(COMMAND_SMITE_NOTIFY, (CommandSender)target);
            }
            return true;
        });
    }
}

