/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.module.essential.object.TimeAlias;
import su.nightexpress.sunlight.utils.WorldTime;

public class PlayerTimeCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION_ROOT = EssentialPerms.COMMAND.permission("playertime.root");
    private static final Permission PERMISSION_SET = EssentialPerms.COMMAND.permission("playertime.set");
    private static final Permission PERMISSION_SET_OTHERS = EssentialPerms.COMMAND.permission("playertime.set.others");
    private static final Permission PERMISSION_RESET = EssentialPerms.COMMAND.permission("playertime.reset");
    private static final Permission PERMISSION_RESET_OTHERS = EssentialPerms.COMMAND.permission("playertime.reset.others");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.PlayerTime.Root.Desc").text("Player time commands.");
    private static final TextLocale DESCRIPTION_SET = LangEntry.builder((String)"Command.PlayerTime.Set.Desc").text("Set individual player time.");
    private static final TextLocale DESCRIPTION_SET_TIME = LangEntry.builder((String)"Command.PlayerTime.SetTime.Desc").text("Set individual player time to %s ticks.");
    private static final TextLocale DESCRIPTION_RESET = LangEntry.builder((String)"Command.PlayerTime.Reset.Desc").text("Reset individual player time.");
    private static final MessageLocale MESSAGE_SET_FEEDBACK = LangEntry.builder((String)"Command.Time.Personal.Set.Target").chatMessage(TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s time to " + TagWrappers.SOFT_YELLOW.wrap("%time%") + " (" + TagWrappers.WHITE.wrap("%total% ticks") + ")."));
    private static final MessageLocale MESSAGE_SET_NOTIFY = LangEntry.builder((String)"Command.Time.Personal.Set.Notify").chatMessage(TagWrappers.GRAY.wrap("Your personal time has been set to " + TagWrappers.SOFT_YELLOW.wrap("%time%") + " (" + TagWrappers.WHITE.wrap("%total% ticks") + ")."));
    private static final MessageLocale MESSAGE_RESET_FEEDBACK = LangEntry.builder((String)"Command.Time.Personal.Reset.Target").chatMessage(TagWrappers.GRAY.wrap("You have reset " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%") + "'s time."));
    private static final MessageLocale MESSAGE_RESET_NOTIFY = LangEntry.builder((String)"Command.Time.Personal.Reset.Notify").chatMessage(TagWrappers.GRAY.wrap("Your personal time has been reset."));
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_RESET = "reset";
    private final EssentialModule module;
    private final EssentialSettings settings;
    private final Set<TimeAlias> timeAliases;

    public PlayerTimeCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.timeAliases = new LinkedHashSet<TimeAlias>();
        ((Map)this.settings.timeAliases.get()).forEach((name, gameTime) -> this.timeAliases.add(new TimeAlias(LowerCase.INTERNAL.apply(name), (long)gameTime)));
    }

    @Override
    public void registerDefaults() {
        LinkedHashMap<String, String> rootChildrens = new LinkedHashMap<String, String>();
        rootChildrens.put(COMMAND_SET, COMMAND_SET);
        rootChildrens.put(COMMAND_RESET, COMMAND_RESET);
        this.timeAliases.forEach(timeAlias -> {
            String name = timeAlias.name();
            long time = timeAlias.gameTime();
            this.registerLiteral(name, false, new String[]{"p" + name}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_SET_TIME.text().formatted(String.valueOf(time)))).permission(PERMISSION_SET)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_SET_OTHERS)).optional()}).executes((context, arguments) -> this.setPlayerTime(context, arguments, time)));
            rootChildrens.put(name, name);
        });
        this.registerLiteral(COMMAND_SET, false, new String[]{"setplayertime"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_SET)).permission(PERMISSION_SET)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"time", (int)0, (int)24000).localized(Lang.COMMAND_ARGUMENT_NAME_TIME).suggestions((reader, context) -> IntStream.range(0, 25).boxed().map(hour -> (long)hour.intValue() * 1000L).map(String::valueOf).toList()), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_SET_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.setPlayerTime(context, arguments, arguments.getInt("time"))));
        this.registerLiteral(COMMAND_RESET, false, new String[]{"resetplayertime"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_RESET.text())).permission(PERMISSION_RESET)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_RESET_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::clearPlayerTime));
        this.registerRoot("Player Time", true, new String[]{"playertime", "ptime"}, rootChildrens, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    private boolean setPlayerTime(@NotNull CommandContext context, @NotNull ParsedArguments arguments, long ticks) {
        return this.forOnlinePlayerOrSender(context, arguments, target -> {
            long finalTicks = WorldTime.clamp(ticks);
            target.setPlayerTime(finalTicks, true);
            long totalTicks = target.getPlayerTime() % 24000L;
            LocalTime time = WorldTime.getTimeOfTicks(totalTicks);
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_SET_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%time%", () -> SLUtils.formatTime(time)).with("%total%", () -> NumberUtil.format((double)totalTicks)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_SET_NOTIFY, (CommandSender)target, replacer -> replacer.with("%time%", () -> SLUtils.formatTime(time)).with("%total%", () -> NumberUtil.format((double)totalTicks)));
            }
            return true;
        });
    }

    private boolean clearPlayerTime(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.forOnlinePlayerOrSender(context, arguments, target -> {
            target.resetPlayerTime();
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_RESET_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_RESET_NOTIFY, (CommandSender)target);
            }
            return true;
        });
    }
}

