/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.net.InetAddress;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.BooleanLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.user.UserManager;

public class PlayerInfoCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("playerinfo");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.PlayerInfo.Desc").text("Show player info.");
    private static final BooleanLocale STATUS = LangEntry.builder((String)"Command.PlayerInfo.Status").bool(TagWrappers.GREEN.wrap("Online"), TagWrappers.RED.wrap("Offline"));
    private final EssentialSettings settings;
    private final UserManager userManager;

    public PlayerInfoCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialSettings settings, @NotNull UserManager userManager) {
        super(plugin);
        this.settings = settings;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("playerinfo", true, new String[]{"playerinfo", "pinfo"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player")}).executes(this::showPlayerInfo));
    }

    private boolean showPlayerInfo(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        this.loadUserWithPlayerDataAsync(context, arguments, this.userManager, (user, target) -> {
            Location location = target.getLocation();
            Replacer replacer = Replacer.create().replace(SLPlaceholders.forPlayerWithPAPI((Player)target)).replace(SLPlaceholders.forLocation((Location)location)).replace("%player_status%", () -> STATUS.get(user.isOnline())).replace("%player_ip%", () -> user.getLatestAddress().map(InetAddress::getHostAddress).orElse("null")).replace("%player_level%", () -> NumberUtil.format((double)target.getLevel())).replace("%player_can_fly%", () -> CoreLang.STATE_YES_NO.get(target.getAllowFlight())).replace("%player_food_level%", () -> NumberUtil.format((double)target.getFoodLevel())).replace("%player_saturation%", () -> NumberUtil.format((double)target.getSaturation())).replace("%player_max_health%", () -> NumberUtil.format((double)EntityUtil.getAttributeValue((LivingEntity)target, (Attribute)Attribute.MAX_HEALTH))).replace("%player_health%", () -> NumberUtil.format((double)target.getHealth())).replace("%player_gamemode%", () -> Lang.GAME_MODE.getLocalized((Enum)target.getGameMode())).replace("%player_vanished%", () -> CoreLang.STATE_YES_NO.get(user.isVanished()));
            String text = String.join((CharSequence)"\n", replacer.apply((List)this.settings.playerInfoFormat.get()));
            Players.sendMessage((CommandSender)context.getSender(), (String)text);
        });
        return true;
    }
}

