/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Map;
import java.util.stream.IntStream;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ModifyMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.user.UserManager;

public class FoodLevelCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_RESTORE = "restore";
    private static final String COMMAND_ADD = "add";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_REMOVE = "remove";
    private static final Permission PERM_ADD = EssentialPerms.COMMAND.permission("foodlevel.add");
    private static final Permission PERM_SET = EssentialPerms.COMMAND.permission("foodlevel.set");
    private static final Permission PERM_REMOVE = EssentialPerms.COMMAND.permission("foodlevel.remove");
    private static final Permission PERM_RESTORE = EssentialPerms.COMMAND.permission("foodlevel.restore");
    private static final Permission PERM_ROOT = EssentialPerms.COMMAND.permission("foodlevel.root");
    private static final Permission PERM_OTHERS = EssentialPerms.COMMAND.permission("foodlevel.others");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Food.Root.Desc").text("Food level commands.");
    private static final TextLocale DESCRIPTION_ADD = LangEntry.builder((String)"Command.Food.Add.Desc").text("Add food points.");
    private static final TextLocale DESCRIPTION_SET = LangEntry.builder((String)"Command.Food.Set.Desc").text("Set food level.");
    private static final TextLocale DESCRIPTION_REMOVE = LangEntry.builder((String)"Command.Food.Remove.Desc").text("Remove food points.");
    private static final TextLocale DESCRIPTION_RESTORE = LangEntry.builder((String)"Command.Food.Restore.Desc").text("Restore food level.");
    private static final MessageLocale MESSAGE_ADD_FEEDBACK = LangEntry.builder((String)"Command.Food.Give.Target").chatMessage(TagWrappers.GRAY.wrap("You have " + TagWrappers.GREEN.wrap("added %amount%") + " food points to " + TagWrappers.WHITE.wrap("%player_display_name%") + " (" + TagWrappers.WHITE.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")"));
    private static final MessageLocale MESSAGE_REMOVE_FEEDBACK = LangEntry.builder((String)"Command.Food.Take.Target").chatMessage(TagWrappers.GRAY.wrap("You have " + TagWrappers.RED.wrap("removed %amount%") + " food points from " + TagWrappers.WHITE.wrap("%player_display_name%") + " (" + TagWrappers.WHITE.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.RED.wrap("%newvalue%") + ")"));
    private static final MessageLocale MESSAGE_SET_FEEDBACK = LangEntry.builder((String)"Command.Food.Set.Target").chatMessage(TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s food level to " + TagWrappers.YELLOW.wrap("%amount%") + " (" + TagWrappers.WHITE.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.YELLOW.wrap("%newvalue%") + ")"));
    private static final MessageLocale MESSAGE_ADD_NOTIFY = LangEntry.builder((String)"Command.Food.Give.Notify").chatMessage(TagWrappers.GRAY.wrap("Your food level has been increased by " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + "."));
    private static final MessageLocale MESSAGE_REMOVE_NOTIFY = LangEntry.builder((String)"Command.Food.Take.Notify").chatMessage(TagWrappers.GRAY.wrap("Your food level has been decreased by " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + "."));
    private static final MessageLocale MESSAGE_SET_NOTIFY = LangEntry.builder((String)"Command.Food.Set.Notify").chatMessage(TagWrappers.GRAY.wrap("Your food level has been set to " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + "."));
    private static final MessageLocale MESSAGE_RESTORE_NOTIFY = LangEntry.builder((String)"Command.Food.Restore.Notify").chatMessage(Sound.ENTITY_GENERIC_EAT, new String[]{TagWrappers.GRAY.wrap("You have been fed!")});
    private static final MessageLocale MESSAGE_RESTORE_FEEDBACK = LangEntry.builder((String)"Command.Food.Restore.Info").chatMessage(Sound.ENTITY_GENERIC_EAT, new String[]{TagWrappers.GRAY.wrap("You have fed " + TagWrappers.WHITE.wrap("%player_display_name%") + ".")});
    private static final int MAX_VALUE = 20;
    private final EssentialModule module;
    private final EssentialSettings settings;
    private final UserManager userManager;

    public FoodLevelCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.settings = settings;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_ADD, false, new String[]{"addfood"}, builder -> this.builderMode((LiteralNodeBuilder)builder, ModifyMode.ADD));
        this.registerLiteral(COMMAND_SET, false, new String[]{"setfood"}, builder -> this.builderMode((LiteralNodeBuilder)builder, ModifyMode.SET));
        this.registerLiteral(COMMAND_REMOVE, false, new String[]{"removefood"}, builder -> this.builderMode((LiteralNodeBuilder)builder, ModifyMode.REMOVE));
        this.registerLiteral(COMMAND_RESTORE, true, new String[]{"feed"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION_RESTORE)).permission(PERM_RESTORE)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERM_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::restoreFood));
        this.registerRoot("Food Level", true, new String[]{"foodlevel"}, Map.of(COMMAND_ADD, COMMAND_ADD, COMMAND_SET, COMMAND_SET, COMMAND_REMOVE, COMMAND_REMOVE, COMMAND_RESTORE, COMMAND_RESTORE), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERM_ROOT));
    }

    private void builderMode(@NotNull LiteralNodeBuilder builder, @NotNull ModifyMode mode) {
        TextLocale description = switch (mode) {
            default -> throw new MatchException(null, null);
            case ModifyMode.ADD -> DESCRIPTION_ADD;
            case ModifyMode.SET -> DESCRIPTION_SET;
            case ModifyMode.REMOVE -> DESCRIPTION_REMOVE;
        };
        Permission permission = switch (mode) {
            default -> throw new MatchException(null, null);
            case ModifyMode.ADD -> PERM_ADD;
            case ModifyMode.SET -> PERM_SET;
            case ModifyMode.REMOVE -> PERM_REMOVE;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(permission)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"amount", (int)0).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> IntStream.range(0, 21).boxed().map(String::valueOf).toList()), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERM_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.modifyFood(context, arguments, mode));
    }

    private boolean modifyFood(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ModifyMode mode) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            MessageLocale notifyMessage;
            int amount = arguments.getInt("amount");
            int oldValue = target.getFoodLevel();
            int newValue = (int)Math.clamp(mode.modify(oldValue, amount), 0.0, 20.0);
            target.setFoodLevel(newValue);
            if (!target.isOnline()) {
                target.saveData();
            }
            MessageLocale infoMessage = switch (mode) {
                default -> throw new MatchException(null, null);
                case ModifyMode.SET -> MESSAGE_SET_FEEDBACK;
                case ModifyMode.REMOVE -> MESSAGE_REMOVE_FEEDBACK;
                case ModifyMode.ADD -> MESSAGE_ADD_FEEDBACK;
            };
            switch (mode) {
                default: {
                    throw new MatchException(null, null);
                }
                case ADD: {
                    MessageLocale messageLocale = MESSAGE_ADD_NOTIFY;
                    break;
                }
                case SET: {
                    MessageLocale messageLocale = MESSAGE_SET_NOTIFY;
                    break;
                }
                case REMOVE: {
                    MessageLocale messageLocale = notifyMessage = MESSAGE_REMOVE_NOTIFY;
                }
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(infoMessage, context.getSender(), builder -> builder.with("%newvalue%", () -> NumberUtil.format((double)target.getFoodLevel())).with("%oldvalue%", () -> NumberUtil.format((double)oldValue)).with("%max%", () -> NumberUtil.format((double)20.0)).with("%amount%", () -> NumberUtil.format((double)amount)).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(notifyMessage, (CommandSender)target, builder -> builder.with("%newvalue%", () -> NumberUtil.format((double)target.getFoodLevel())).with("%oldvalue%", () -> NumberUtil.format((double)oldValue)).with("%max%", () -> NumberUtil.format((double)20.0)).with("%amount%", () -> NumberUtil.format((double)amount)));
            }
        });
    }

    private boolean restoreFood(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            target.setFoodLevel(20);
            if (((Boolean)this.settings.foodSaturationEnabled.get()).booleanValue()) {
                target.setSaturation(Math.min(20.0f, target.getSaturation() + ((Double)this.settings.foodSaturationAmount.get()).floatValue()));
            }
            if (!target.isOnline()) {
                target.saveData();
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(MESSAGE_RESTORE_FEEDBACK, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_RESTORE_NOTIFY, (CommandSender)target);
            }
        });
    }
}

