/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ModifyMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.user.UserManager;

public class ExperienceCommandsProvider
extends AbstractCommandProvider {
    private static final String COMMAND_LEVEL_ADD = "level_add";
    private static final String COMMAND_LEVEL_SET = "level_set";
    private static final String COMMAND_LEVEL_REMOVE = "level_remove";
    private static final String COMMAND_XP_ADD = "xp_add";
    private static final String COMMAND_XP_SET = "xp_set";
    private static final String COMMAND_XP_REMOVE = "xp_remove";
    private static final Permission PERMISSION_LEVEL = EssentialPerms.COMMAND.permission("experience.level");
    private static final Permission PERMISSION_LEVEL_OTHERS = EssentialPerms.COMMAND.permission("experience.level.others");
    private static final Permission PERMISSION_XP = EssentialPerms.COMMAND.permission("experience.xp");
    private static final Permission PERMISSION_XP_OTHERS = EssentialPerms.COMMAND.permission("experience.xp.others");
    private static final Permission PERMISSION_ROOT = EssentialPerms.COMMAND.permission("experience.root");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Experience.Root.Desc").text("Experience commands.");
    private static final TextLocale DESCRIPTION_LEVEL_ADD = LangEntry.builder((String)"Command.Experience.AddLevel.Desc").text("Add XP levels.");
    private static final TextLocale DESCRIPTION_LEVEL_SET = LangEntry.builder((String)"Command.Experience.SetLevel.Desc").text("Set XP levels.");
    private static final TextLocale DESCRIPTION_LEVEL_REMOVE = LangEntry.builder((String)"Command.Experience.RemoveLevel.Desc").text("Remove XP levels.");
    private static final TextLocale DESCRIPTION_XP_ADD = LangEntry.builder((String)"Command.Experience.AddXP.Desc").text("Add experience points.");
    private static final TextLocale DESCRIPTION_XP_SET = LangEntry.builder((String)"Command.Experience.SetXP.Desc").text("Set experience points.");
    private static final TextLocale DESCRIPTION_XP_REMOVE = LangEntry.builder((String)"Command.Experience.RemoveXP.Desc").text("Remove experience points.");
    private static final MessageLocale MESSAGE_XP_SET_FEEDBACK = LangEntry.builder((String)"Command.Experience.SetXP.Feedback").chatMessage(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s total XP to " + TagWrappers.SOFT_YELLOW.wrap("%value%") + " (" + TagWrappers.YELLOW.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")")});
    private static final MessageLocale MESSAGE_XP_SET_NOTIFY = LangEntry.builder((String)"Command.Experience.SetXP.Notify").chatMessage(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, new String[]{TagWrappers.GRAY.wrap("Your total XP has been set to " + TagWrappers.SOFT_YELLOW.wrap("%value%") + ".")});
    private static final MessageLocale MESSAGE_XP_ADD_FEEDBACK = LangEntry.builder((String)"Command.Experience.AddXP.Feedback").chatMessage(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have added " + TagWrappers.SOFT_GREEN.wrap("%value%") + " XP to " + TagWrappers.WHITE.wrap("%player_display_name%") + " (" + TagWrappers.YELLOW.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")")});
    private static final MessageLocale MESSAGE_XP_ADD_NOTIFY = LangEntry.builder((String)"Command.Experience.AddXP.Notify").chatMessage(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have been given " + TagWrappers.SOFT_GREEN.wrap("%value%") + " XP.")});
    private static final MessageLocale MESSAGE_XP_REMOVE_FEEDBACK = LangEntry.builder((String)"Command.Experience.RemoveXP.Feedback").chatMessage(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have took " + TagWrappers.SOFT_RED.wrap("%value%") + " XP from " + TagWrappers.WHITE.wrap("%player_display_name%") + " (" + TagWrappers.YELLOW.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")")});
    private static final MessageLocale MESSAGE_XP_REMOVE_NOTIFY = LangEntry.builder((String)"Command.Experience.RemoveXP.Notify").chatMessage(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, new String[]{TagWrappers.GRAY.wrap("You have been taken " + TagWrappers.SOFT_RED.wrap("%value%") + " XP.")});
    private static final MessageLocale MESSAGE_LEVEL_SET_FEEDBACK = LangEntry.builder((String)"Command.Experience.SetLevel.Feedback").chatMessage(Sound.ENTITY_PLAYER_LEVELUP, new String[]{TagWrappers.GRAY.wrap("You have set " + TagWrappers.WHITE.wrap("%player_display_name%") + "'s XP level to " + TagWrappers.SOFT_YELLOW.wrap("%value%") + " (" + TagWrappers.YELLOW.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")")});
    private static final MessageLocale MESSAGE_LEVEL_SET_NOTIFY = LangEntry.builder((String)"Command.Experience.SetLevel.Notify").chatMessage(Sound.ENTITY_PLAYER_LEVELUP, new String[]{TagWrappers.GRAY.wrap("Your XP level has been set to " + TagWrappers.SOFT_YELLOW.wrap("%value%") + ".")});
    private static final MessageLocale MESSAGE_LEVEL_ADD_FEEDBACK = LangEntry.builder((String)"Command.Experience.AddLevel.Feedback").chatMessage(Sound.ENTITY_PLAYER_LEVELUP, new String[]{TagWrappers.GRAY.wrap("You have added " + TagWrappers.SOFT_GREEN.wrap("%value%") + " XP levels to " + TagWrappers.WHITE.wrap("%player_display_name%") + " (" + TagWrappers.YELLOW.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")")});
    private static final MessageLocale MESSAGE_LEVEL_ADD_NOTIFY = LangEntry.builder((String)"Command.Experience.AddLevel.Notify").chatMessage(Sound.ENTITY_PLAYER_LEVELUP, new String[]{TagWrappers.GRAY.wrap("You have been given " + TagWrappers.SOFT_GREEN.wrap("%value%") + " XP levels.")});
    private static final MessageLocale MESSAGE_LEVEL_REMOVE_FEEDBACK = LangEntry.builder((String)"Command.Experience.RemoveLevel.Feedback").chatMessage(Sound.ENTITY_PLAYER_LEVELUP, new String[]{TagWrappers.GRAY.wrap("You have took " + TagWrappers.SOFT_RED.wrap("%value%") + " XP levels from " + TagWrappers.WHITE.wrap("%player_display_name%") + " (" + TagWrappers.YELLOW.wrap("%oldvalue%") + TagWrappers.DARK_GRAY.wrap(" \u2192 ") + TagWrappers.GREEN.wrap("%newvalue%") + ")")});
    private static final MessageLocale MESSAGE_LEVEL_REMOVE_NOTIFY = LangEntry.builder((String)"Command.Experience.RemoveLevel.Notify").chatMessage(Sound.ENTITY_PLAYER_LEVELUP, new String[]{TagWrappers.GRAY.wrap("You have been taken " + TagWrappers.SOFT_RED.wrap("%value%") + " XP levels.")});
    private final EssentialModule module;
    private final UserManager userManager;

    public ExperienceCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_LEVEL_ADD, true, new String[]{"addlevel"}, builder -> this.buildLevelCommand((LiteralNodeBuilder)builder, DESCRIPTION_LEVEL_ADD, ModifyMode.ADD));
        this.registerLiteral(COMMAND_LEVEL_SET, true, new String[]{"setlevel"}, builder -> this.buildLevelCommand((LiteralNodeBuilder)builder, DESCRIPTION_LEVEL_SET, ModifyMode.SET));
        this.registerLiteral(COMMAND_LEVEL_REMOVE, true, new String[]{"removelevel"}, builder -> this.buildLevelCommand((LiteralNodeBuilder)builder, DESCRIPTION_LEVEL_REMOVE, ModifyMode.REMOVE));
        this.registerLiteral(COMMAND_XP_ADD, true, new String[]{"addxp"}, builder -> this.buildXPCommand((LiteralNodeBuilder)builder, DESCRIPTION_XP_ADD, ModifyMode.ADD));
        this.registerLiteral(COMMAND_XP_SET, true, new String[]{"setxp"}, builder -> this.buildXPCommand((LiteralNodeBuilder)builder, DESCRIPTION_XP_SET, ModifyMode.SET));
        this.registerLiteral(COMMAND_XP_REMOVE, true, new String[]{"removexp"}, builder -> this.buildXPCommand((LiteralNodeBuilder)builder, DESCRIPTION_XP_REMOVE, ModifyMode.REMOVE));
        this.registerRoot("XP", true, new String[]{"experience", "exp", "xp"}, Map.of(COMMAND_XP_ADD, "add", COMMAND_XP_SET, "set", COMMAND_XP_REMOVE, "remove", COMMAND_LEVEL_ADD, "addlevel", COMMAND_LEVEL_SET, "setlevel", COMMAND_LEVEL_REMOVE, "removelevel"), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    private void buildLevelCommand(@NotNull LiteralNodeBuilder builder, @NotNull TextLocale description, @NotNull ModifyMode mode) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(PERMISSION_LEVEL)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"amount").localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT.text()), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_LEVEL_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.changeLevels(context, arguments, mode));
    }

    private void buildXPCommand(@NotNull LiteralNodeBuilder builder, @NotNull TextLocale description, @NotNull ModifyMode mode) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(PERMISSION_XP)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"amount").localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT.text()), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_XP_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.changeXP(context, arguments, mode));
    }

    private boolean changeXP(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ModifyMode mode) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            MessageLocale notifyMessage;
            MessageLocale feedbackMessage;
            int amount = arguments.getInt("amount");
            int oldXP = target.getTotalExperience();
            switch (mode) {
                case SET: {
                    target.setTotalExperience(0);
                    target.setLevel(0);
                    target.setExp(0.0f);
                    target.giveExp(amount);
                    feedbackMessage = MESSAGE_XP_SET_FEEDBACK;
                    notifyMessage = MESSAGE_XP_SET_NOTIFY;
                    break;
                }
                case ADD: {
                    target.giveExp(amount);
                    feedbackMessage = MESSAGE_XP_ADD_FEEDBACK;
                    notifyMessage = MESSAGE_XP_ADD_NOTIFY;
                    break;
                }
                case REMOVE: {
                    target.giveExp(-amount);
                    feedbackMessage = MESSAGE_XP_REMOVE_FEEDBACK;
                    notifyMessage = MESSAGE_XP_REMOVE_NOTIFY;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!target.isOnline()) {
                target.saveData();
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(feedbackMessage, context.getSender(), builder -> builder.with("%value%", () -> NumberUtil.format((double)amount)).with("%oldvalue%", () -> NumberUtil.format((double)oldXP)).with("%newvalue%", () -> NumberUtil.format((double)target.getTotalExperience())).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(notifyMessage, (CommandSender)target, builder -> builder.with("%value%", () -> NumberUtil.format((double)amount)).with("%oldvalue%", () -> NumberUtil.format((double)oldXP)).with("%newvalue%", () -> NumberUtil.format((double)target.getTotalExperience())));
            }
        });
    }

    private boolean changeLevels(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ModifyMode mode) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            MessageLocale notifyMessage;
            MessageLocale feedbackMessage;
            int amount = arguments.getInt("amount");
            int oldLevel = target.getLevel();
            switch (mode) {
                case SET: {
                    target.setLevel(amount);
                    feedbackMessage = MESSAGE_LEVEL_SET_FEEDBACK;
                    notifyMessage = MESSAGE_LEVEL_SET_NOTIFY;
                    break;
                }
                case ADD: {
                    target.giveExpLevels(amount);
                    feedbackMessage = MESSAGE_LEVEL_ADD_FEEDBACK;
                    notifyMessage = MESSAGE_LEVEL_ADD_NOTIFY;
                    break;
                }
                case REMOVE: {
                    target.giveExpLevels(-amount);
                    feedbackMessage = MESSAGE_LEVEL_REMOVE_FEEDBACK;
                    notifyMessage = MESSAGE_LEVEL_REMOVE_NOTIFY;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!target.isOnline()) {
                target.saveData();
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(feedbackMessage, context.getSender(), builder -> builder.with("%value%", () -> NumberUtil.format((double)amount)).with("%oldvalue%", () -> NumberUtil.format((double)oldLevel)).with("%newvalue%", () -> NumberUtil.format((double)target.getLevel())).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(notifyMessage, (CommandSender)target, builder -> builder.with("%value%", () -> NumberUtil.format((double)amount)).with("%oldvalue%", () -> NumberUtil.format((double)oldLevel)).with("%newvalue%", () -> NumberUtil.format((double)target.getLevel())));
            }
        });
    }
}

