/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.NightMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;

public class DisposalCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("disposal");
    private static final Permission PERMISSION_OTHERS = EssentialPerms.COMMAND.permission("disposal.others");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Disposal.Desc").text("Opens Virtual Disposal.");
    private static final MessageLocale MESSAGE_FEEDBACK = LangEntry.builder((String)"Command.Disposal.Target").chatMessage(TagWrappers.GRAY.wrap("You have opened " + TagWrappers.ORANGE.wrap("Virtual Disposal") + " for " + TagWrappers.WHITE.wrap("%player_display_name%") + "."));
    private static final MessageLocale MESSAGE_NOTIFY = LangEntry.builder((String)"Command.Disposal.Notify").chatMessage(TagWrappers.GRAY.wrap("You have opened " + TagWrappers.ORANGE.wrap("Virtual Disposal.")));
    private final EssentialModule module;
    private final EssentialSettings settings;

    public DisposalCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull EssentialSettings settings) {
        super(plugin);
        this.module = module;
        this.settings = settings;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("disposal", true, new String[]{"disposal", "trash"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(PERMISSION_OTHERS)}).withFlags(new String[]{"s"}).executes(this::openDisposal));
    }

    private boolean openDisposal(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.forOnlinePlayerOrSender(context, arguments, target -> {
            Inventory inventory = this.plugin.getServer().createInventory(null, ((Integer)this.settings.disposalSize.get()).intValue(), NightMessage.asLegacy((String)((String)this.settings.disposalTitle.get())));
            target.openInventory(inventory);
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(MESSAGE_NOTIFY, (CommandSender)target);
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(MESSAGE_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            return true;
        });
    }
}

