/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.language.LangAssets;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.user.UserManager;

public class DimensionCommandProvider
extends AbstractCommandProvider {
    private static final Permission PERMISSION = EssentialPerms.COMMAND.permission("dimension");
    private static final Permission PERMISSION_OTHERS = EssentialPerms.COMMAND.permission("dimension.others");
    private static final TextLocale DESCRIPTION = LangEntry.builder((String)"Command.Dimension.Desc").text("Teleport to a world.");
    private static final MessageLocale MESSAGE_FEEDBACK = LangEntry.builder((String)"Command.Dimension.Target").chatMessage(TagWrappers.GRAY.wrap("You've teleported player " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%") + " to the " + TagWrappers.SOFT_YELLOW.wrap("%world%") + "."));
    private static final MessageLocale MESSAGE_NOTIFY = LangEntry.builder((String)"Command.Dimension.Notify").chatMessage(Sound.ENTITY_ENDERMAN_TELEPORT, new String[]{TagWrappers.GRAY.wrap("You have teleported to the " + TagWrappers.ORANGE.wrap("%world%") + ".")});
    private final EssentialModule module;
    private final UserManager userManager;
    private final TeleportManager teleportManager;

    public DimensionCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager, @NotNull TeleportManager teleportManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
        this.teleportManager = teleportManager;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("dimension", true, new String[]{"dimension", "dim"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(DESCRIPTION)).permission(PERMISSION)).withArguments(new ArgumentNodeBuilder[]{Arguments.world((String)"world"), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes(this::execute));
    }

    private boolean execute(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            World world = arguments.getWorld("world");
            this.teleportManager.moveExact((Player)target, world.getSpawnLocation(), () -> {
                if (context.getSender() != target) {
                    this.module.sendPrefixed(MESSAGE_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)).with("%world%", () -> LangAssets.get((World)world)));
                }
                if (!context.hasFlag("s")) {
                    this.module.sendPrefixed(MESSAGE_NOTIFY, (CommandSender)target, builder -> builder.with("%world%", () -> LangAssets.get((World)world)));
                }
            });
        });
    }
}

