/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential.command;

import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ModifyMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.essential.EssentialModule;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.user.UserManager;

public class AirCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_ADD = "add";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_REMOVE = "remove";
    private static final Permission PERMISSION_ROOT = EssentialPerms.COMMAND.permission("air.root");
    private static final Permission PERMISSION_ADD = EssentialPerms.COMMAND.permission("air.add");
    private static final Permission PERMISSION_SET = EssentialPerms.COMMAND.permission("air.set");
    private static final Permission PERMISSION_REMOVE = EssentialPerms.COMMAND.permission("air.remove");
    private static final Permission PERMISSION_OTHERS = EssentialPerms.COMMAND.permission("air.others");
    private static final TextLocale DESCRIPTION_ROOT = LangEntry.builder((String)"Command.Air.Root.Desc").text("Add commands.");
    private static final TextLocale DESCRIPTION_ADD = LangEntry.builder((String)"Command.Air.Add.Desc").text("Add air ticks.");
    private static final TextLocale DESCRIPTION_SET = LangEntry.builder((String)"Command.Air.Set.Desc").text("Set air ticks.");
    private static final TextLocale DESCRIPTION_REMOVE = LangEntry.builder((String)"Command.Air.Remove.Desc").text("Remove air ticks.");
    private static final MessageLocale ADD_TARGET = LangEntry.builder((String)"Command.Air.Give.Target").chatMessage(TagWrappers.GRAY.wrap("You have added " + TagWrappers.GREEN.wrap("%amount%") + " air ticks to " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%") + ". New air ticks: " + TagWrappers.SOFT_YELLOW.wrap("%current%") + "/" + TagWrappers.SOFT_YELLOW.wrap("%max%") + "."));
    private static final MessageLocale REMOVE_TARGET = LangEntry.builder((String)"Command.Air.Take.Target").chatMessage(TagWrappers.GRAY.wrap("You have removed " + TagWrappers.RED.wrap("%amount%") + " air ticks from " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%") + ". New air ticks: " + TagWrappers.SOFT_YELLOW.wrap("%current%") + "/" + TagWrappers.SOFT_YELLOW.wrap("%max%") + "."));
    private static final MessageLocale SET_TARGET = LangEntry.builder((String)"Command.Air.Set.Target").chatMessage(TagWrappers.GRAY.wrap("You have set " + TagWrappers.YELLOW.wrap("%amount%") + " air ticks for " + TagWrappers.SOFT_YELLOW.wrap("%player_display_name%") + ". New air ticks: " + TagWrappers.SOFT_YELLOW.wrap("%current%") + "/" + TagWrappers.SOFT_YELLOW.wrap("%max%") + "."));
    private static final MessageLocale ADD_NOTIFY = LangEntry.builder((String)"Command.Air.Give.Notify").chatMessage(TagWrappers.GRAY.wrap("You got " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + " air ticks: " + TagWrappers.SOFT_YELLOW.wrap("%current%") + "/" + TagWrappers.SOFT_YELLOW.wrap("%max%") + "."));
    private static final MessageLocale REMOVE_NOTIFY = LangEntry.builder((String)"Command.Air.Take.Notify").chatMessage(TagWrappers.GRAY.wrap("You lost " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + " air ticks: " + TagWrappers.SOFT_YELLOW.wrap("%current%") + "/" + TagWrappers.SOFT_YELLOW.wrap("%max%") + "."));
    private static final MessageLocale SET_NOTIFY = LangEntry.builder((String)"Command.Air.Set.Notify").chatMessage(TagWrappers.GRAY.wrap("Your air ticks set to " + TagWrappers.SOFT_YELLOW.wrap("%amount%") + ": " + TagWrappers.SOFT_YELLOW.wrap("%current%") + "/" + TagWrappers.SOFT_YELLOW.wrap("%max%") + "."));
    private final EssentialModule module;
    private final UserManager userManager;

    public AirCommandProvider(@NotNull SunLightPlugin plugin, @NotNull EssentialModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_ADD, false, new String[]{"addair"}, builder -> this.buildExecutor((LiteralNodeBuilder)builder, ModifyMode.ADD));
        this.registerLiteral(COMMAND_SET, false, new String[]{"setair"}, builder -> this.buildExecutor((LiteralNodeBuilder)builder, ModifyMode.SET));
        this.registerLiteral(COMMAND_REMOVE, false, new String[]{"removeair"}, builder -> this.buildExecutor((LiteralNodeBuilder)builder, ModifyMode.REMOVE));
        this.registerRoot("Air", true, new String[]{"air"}, Map.of(COMMAND_ADD, COMMAND_ADD, COMMAND_REMOVE, COMMAND_REMOVE, COMMAND_SET, COMMAND_SET), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(DESCRIPTION_ROOT)).permission(PERMISSION_ROOT));
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    private void buildExecutor(@NotNull LiteralNodeBuilder builder, @NotNull ModifyMode mode) {
        TextLocale description = switch (mode) {
            default -> throw new MatchException(null, null);
            case ModifyMode.ADD -> DESCRIPTION_ADD;
            case ModifyMode.SET -> DESCRIPTION_SET;
            case ModifyMode.REMOVE -> DESCRIPTION_REMOVE;
        };
        Permission permission = switch (mode) {
            default -> throw new MatchException(null, null);
            case ModifyMode.ADD -> PERMISSION_ADD;
            case ModifyMode.SET -> PERMISSION_SET;
            case ModifyMode.REMOVE -> PERMISSION_REMOVE;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(permission)).withArguments(new ArgumentNodeBuilder[]{Arguments.integer((String)"amount", (int)0).localized(CoreLang.COMMAND_ARGUMENT_NAME_AMOUNT).suggestions((reader, context) -> Lists.newList((Object[])new String[]{"100", "200", "300", "400", "500"}))}).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PERMISSION_OTHERS)}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.executeMode(context, arguments, mode));
    }

    private boolean executeMode(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ModifyMode mode) {
        int amount = arguments.getInt("amount");
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            MessageLocale notify;
            target.setRemainingAir((int)Math.max(0.0, mode.modify(target.getRemainingAir(), amount)));
            if (!target.isOnline()) {
                target.saveData();
            }
            MessageLocale message = switch (mode) {
                default -> throw new MatchException(null, null);
                case ModifyMode.SET -> SET_TARGET;
                case ModifyMode.REMOVE -> REMOVE_TARGET;
                case ModifyMode.ADD -> ADD_TARGET;
            };
            switch (mode) {
                default: {
                    throw new MatchException(null, null);
                }
                case ADD: {
                    MessageLocale messageLocale = ADD_NOTIFY;
                    break;
                }
                case SET: {
                    MessageLocale messageLocale = SET_NOTIFY;
                    break;
                }
                case REMOVE: {
                    MessageLocale messageLocale = notify = REMOVE_NOTIFY;
                }
            }
            if (target != context.getSender()) {
                this.module.sendPrefixed(message, context.getSender(), replacer -> replacer.with("%current%", () -> String.valueOf(target.getRemainingAir())).with("%max%", () -> String.valueOf(target.getMaximumAir())).with("%amount%", () -> NumberUtil.format((double)amount)).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            if (!context.hasFlag("s")) {
                this.module.sendPrefixed(notify, (CommandSender)target, replacer -> replacer.with("%current%", () -> String.valueOf(target.getRemainingAir())).with("%max%", () -> String.valueOf(target.getMaximumAir())).with("%amount%", () -> NumberUtil.format((double)amount)).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
        });
    }
}

