/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.essential;

import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.permission.PermissionBridge;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.text.NightMessage;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.essential.EssentialListener;
import su.nightexpress.sunlight.module.essential.EssentialPerms;
import su.nightexpress.sunlight.module.essential.EssentialSettings;
import su.nightexpress.sunlight.module.essential.command.AirCommandProvider;
import su.nightexpress.sunlight.module.essential.command.BroadcastCommandProvider;
import su.nightexpress.sunlight.module.essential.command.CondenseCommandProvider;
import su.nightexpress.sunlight.module.essential.command.DimensionCommandProvider;
import su.nightexpress.sunlight.module.essential.command.DisposalCommandProvider;
import su.nightexpress.sunlight.module.essential.command.EnchantCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.ExperienceCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.FireTicksCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.FlyCommandProvider;
import su.nightexpress.sunlight.module.essential.command.FlySpeedCommandProvider;
import su.nightexpress.sunlight.module.essential.command.FoodLevelCommandProvider;
import su.nightexpress.sunlight.module.essential.command.ForceRunCommandProvider;
import su.nightexpress.sunlight.module.essential.command.ForceSayCommandProvider;
import su.nightexpress.sunlight.module.essential.command.GamemodeCommandProvider;
import su.nightexpress.sunlight.module.essential.command.HatCommandProvider;
import su.nightexpress.sunlight.module.essential.command.HealthCommandProvider;
import su.nightexpress.sunlight.module.essential.command.NearCommandProvider;
import su.nightexpress.sunlight.module.essential.command.NickCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.PlayerInfoCommandProvider;
import su.nightexpress.sunlight.module.essential.command.PlayerTimeCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SkullCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SmiteCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SpeedCommandProvider;
import su.nightexpress.sunlight.module.essential.command.StaffCommandProvider;
import su.nightexpress.sunlight.module.essential.command.SuicideCommandProvider;
import su.nightexpress.sunlight.module.essential.command.TeleportCommandsProvider;
import su.nightexpress.sunlight.module.essential.command.TimeCommandProvider;
import su.nightexpress.sunlight.module.essential.command.WeatherCommandProvider;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.user.SunUser;

public class EssentialModule
extends Module {
    private final TeleportManager teleportManager;
    private final EssentialSettings settings;

    public EssentialModule(@NotNull ModuleContext context, @NotNull TeleportManager teleportManager) {
        super(context);
        this.teleportManager = teleportManager;
        this.settings = new EssentialSettings();
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        this.registerCommands();
        this.addListener((SimpeListener)new EssentialListener((SunLightPlugin)this.plugin, this));
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(EssentialPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("air", new AirCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("broadcast", new BroadcastCommandProvider((SunLightPlugin)this.plugin, (List)this.settings.broadcastFormat.get()));
        this.commandRegistry.addProvider("condense", new CondenseCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("dimension", new DimensionCommandProvider((SunLightPlugin)this.plugin, this, this.userManager, this.teleportManager));
        this.commandRegistry.addProvider("disposal", new DisposalCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        this.commandRegistry.addProvider("enchant", new EnchantCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("experience", new ExperienceCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("fireticks", new FireTicksCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("fly", new FlyCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("flyspeed", new FlySpeedCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("foodlevel", new FoodLevelCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("forcerun", new ForceRunCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("forcesay", new ForceSayCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("gamemode", new GamemodeCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("hat", new HatCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("health", new HealthCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("near", new NearCommandProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("nickname", new NickCommandsProvider((SunLightPlugin)this.plugin, this, this.settings, this.userManager));
        this.commandRegistry.addProvider("playerinfo", new PlayerInfoCommandProvider((SunLightPlugin)this.plugin, this.settings, this.userManager));
        this.commandRegistry.addProvider("skull", new SkullCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("smite", new SmiteCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("speed", new SpeedCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        if (PermissionBridge.hasProvider()) {
            this.commandRegistry.addProvider("staff", new StaffCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        }
        this.commandRegistry.addProvider("suicide", new SuicideCommandProvider((SunLightPlugin)this.plugin, this));
        this.commandRegistry.addProvider("teleport", new TeleportCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager, this.teleportManager));
        this.commandRegistry.addProvider("time", new TimeCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        this.commandRegistry.addProvider("playertime", new PlayerTimeCommandProvider((SunLightPlugin)this.plugin, this, this.settings));
        this.commandRegistry.addProvider("weather", new WeatherCommandProvider((SunLightPlugin)this.plugin, this));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    public void updatePlayerName(@NotNull Player player) {
        SunUser user = (SunUser)this.userManager.getOrFetch(player);
        if (!player.hasPermission(NickCommandsProvider.NICK_CHANGE)) {
            user.setCustomName(null);
        }
        if (user.hasCustomName()) {
            String customName = user.getCustomName();
            String noTags = NightMessage.stripTags((String)customName);
            if (!noTags.equalsIgnoreCase(customName)) {
                customName = NightMessage.asLegacy((String)customName);
            }
            player.setDisplayName(customName);
        } else {
            player.setDisplayName(null);
        }
    }
}

