/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.deathmessages;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.random.Rnd;

public class DeathMessage
implements Writeable {
    private final List<String> messages;

    public DeathMessage(@NotNull List<String> messages) {
        this.messages = messages;
    }

    @NotNull
    public static DeathMessage simple(@NotNull String message) {
        return new DeathMessage(Lists.newList((Object[])new String[]{message}));
    }

    @NotNull
    public static DeathMessage read(@NotNull FileConfig config, @NotNull String path) {
        List messages = config.getStringList(path + ".Messages");
        return new DeathMessage(messages);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Messages", this.messages);
    }

    @Nullable
    public String selectMessage() {
        return this.messages.isEmpty() ? null : (String)Rnd.get(this.messages);
    }

    @NotNull
    public List<String> getMessages() {
        return this.messages;
    }
}

