/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.report;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.chat.report.ReportHandler;

public final class ReportProtocolHandler
implements ReportHandler {
    private final SunLightPlugin plugin;
    private Listener listener;

    public ReportProtocolHandler(@NotNull SunLightPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        if (this.listener == null) {
            this.listener = new Listener(this.plugin);
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.listener);
        }
    }

    @Override
    public void unload() {
        if (this.listener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.listener);
            this.listener = null;
        }
    }

    private static class Listener
    extends PacketAdapter {
        private final SunLightPlugin plugin;

        public Listener(@NotNull SunLightPlugin plugin) {
            super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.SERVER_DATA, PacketType.Play.Server.CHAT, PacketType.Play.Server.SYSTEM_CHAT, PacketType.Play.Server.LOGIN});
            this.plugin = plugin;
        }

        public void onPacketSending(PacketEvent event) {
            if (event.getPacketType() == PacketType.Play.Server.LOGIN) {
                PacketContainer container = event.getPacket();
                container.getBooleans().write(4, (Object)true);
            } else if (event.getPacketType() == PacketType.Play.Server.CHAT) {
                PacketContainer container = event.getPacket();
                this.plugin.internals().ifPresent(nms -> {
                    Object finePacket = nms.fineChatPacket(container.getHandle());
                    event.setPacket(new PacketContainer(PacketType.Play.Server.SYSTEM_CHAT, finePacket));
                });
            }
        }
    }
}

