/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.processor.global;

import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.ItemTag;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.module.chat.ChatLang;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.context.FormattedContext;
import su.nightexpress.sunlight.module.chat.processor.ChatProcessor;

public class ItemDisplayProcessor
implements ChatProcessor<FormattedContext> {
    @Override
    public void preProcess(@NotNull ChatModule module, @NotNull FormattedContext context) {
        String placeholder;
        String format = context.getFormat();
        int index = format.indexOf(placeholder = module.getSettings().getItemShowPlaceholder());
        if (index == -1) {
            return;
        }
        ItemStack itemStack = context.getPlayer().getInventory().getItemInMainHand();
        if (itemStack.isEmpty()) {
            module.sendPrefixed(ChatLang.ITEM_SHOW_NOTHING, (CommandSender)context.getPlayer());
            return;
        }
        PlaceholderContext itemContext = PlaceholderContext.builder().with("%item_name%", () -> ItemUtil.getNameSerialized((ItemStack)itemStack)).with("%item_value%", () -> Strings.toBase64((String)ItemTag.getTagString((ItemStack)itemStack))).build();
        String itemFormat = itemContext.apply(module.getSettings().getItemShowFormat());
        context.setFormat(format.replace(placeholder, itemFormat));
    }

    @Override
    public void postProcess(@NotNull ChatModule module, @NotNull FormattedContext context) {
    }
}

