/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.discord;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.GameChatMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.channel.ChatChannel;

public class DiscordHandler
extends SimpleManager<SunLightPlugin> {
    public DiscordHandler(@NotNull SunLightPlugin plugin, @NotNull ChatModule module) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        DiscordSRV.api.subscribe((Object)this);
    }

    protected void onShutdown() {
        DiscordSRV.api.unsubscribe((Object)this);
    }

    public void sendToChannel(@NotNull ChatChannel channel, @NotNull String message) {
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channel.getId());
        if (textChannel != null) {
            textChannel.sendMessage((CharSequence)message).queue();
        }
    }

    @Subscribe(priority=ListenerPriority.HIGHEST)
    public void onChatMessageFromInGame(GameChatMessagePreProcessEvent event) {
        event.setCancelled(true);
    }
}

