/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.context;

import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.module.chat.cache.CachedContent;
import su.nightexpress.sunlight.module.chat.cache.UserChatCache;
import su.nightexpress.sunlight.module.chat.channel.ChatChannel;
import su.nightexpress.sunlight.module.chat.context.FormattedContext;

public class MessageContext
extends FormattedContext {
    private final Set<CommandSender> viewers;
    private ChatChannel channel;

    public MessageContext(@NotNull Player player, @NotNull UserChatCache cache, @NotNull String originalMessage, @NotNull String userFormat, @NotNull ChatChannel channel, @NotNull Set<CommandSender> viewers) {
        super(player, cache, originalMessage);
        this.viewers = viewers;
        this.setChannel(channel);
        this.setFormat(PlaceholderContext.builder().with("%format%", () -> userFormat).with("%message%", () -> "").with(channel.placeholders()).build().apply(channel.getDisplay().format()));
    }

    @NotNull
    public Set<CommandSender> getViewers() {
        return this.viewers;
    }

    @Override
    @Nullable
    public CachedContent getLastContent() {
        return this.cache.getLastMessage();
    }

    @Override
    public void setLastContent(@NotNull String message, long lifeTime) {
        this.cache.setLastMessage(message, lifeTime);
    }

    @NotNull
    public ChatChannel getChannel() {
        return this.channel;
    }

    public void setChannel(@NotNull ChatChannel channel) {
        this.channel = channel;
    }
}

