/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.command;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.chat.ChatLang;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.ChatPerms;
import su.nightexpress.sunlight.module.chat.ChatProperties;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserManager;

public class ConversationCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_MESSAGE = "message";
    private static final String COMMAND_REPLY = "reply";
    private static final String COMMAND_TOGGLE = "toggle";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_OFF = "off";
    private final ChatModule module;
    private final UserManager userManager;

    public ConversationCommandProvider(@NotNull SunLightPlugin plugin, @NotNull ChatModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_MESSAGE, true, new String[]{"msg", "pm", "whisper", "w", "tell"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ChatLang.COMMAND_TELL_DESC)).permission(ChatPerms.COMMAND_TELL)).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player"), Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT)}).executes(this::sendConversationMessage));
        this.registerLiteral(COMMAND_REPLY, true, new String[]{COMMAND_REPLY, "r"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ChatLang.COMMAND_REPLY_DESC)).permission(ChatPerms.COMMAND_REPLY)).withArguments(new ArgumentNodeBuilder[]{Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT)}).executes(this::replyToConversation));
        this.registerLiteral(COMMAND_TOGGLE, false, new String[]{"togglepm", "pmtoggle"}, builder -> this.buildToggleCommand((LiteralNodeBuilder)builder, ChatLang.COMMAND_CONVERSATIONS_TOGGLE_DESC, ToggleMode.TOGGLE));
        this.registerLiteral(COMMAND_ON, false, new String[]{"allowpm"}, builder -> this.buildToggleCommand((LiteralNodeBuilder)builder, ChatLang.COMMAND_CONVERSATIONS_ON_DESC, ToggleMode.ON));
        this.registerLiteral(COMMAND_OFF, false, new String[]{"denypm"}, builder -> this.buildToggleCommand((LiteralNodeBuilder)builder, ChatLang.COMMAND_CONVERSATIONS_OFF_DESC, ToggleMode.OFF));
        this.registerRoot("Conversations", true, new String[]{"conversations", "dm"}, Map.of(COMMAND_MESSAGE, "send", COMMAND_REPLY, COMMAND_REPLY, COMMAND_TOGGLE, COMMAND_TOGGLE, COMMAND_ON, COMMAND_ON, COMMAND_OFF, COMMAND_OFF), (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(ChatLang.COMMAND_CONVERSATIONS_ROOT_DESC)).permission(ChatPerms.COMMAND_CONVERSATIONS_ROOT));
    }

    private void buildToggleCommand(@NotNull LiteralNodeBuilder builder, @NotNull TextLocale description, @NotNull ToggleMode mode) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(ChatPerms.COMMAND_CONVERSATIONS_TOGGLE)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(ChatPerms.COMMAND_CONVERSATIONS_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleConversations(context, arguments, mode));
    }

    private boolean sendConversationMessage(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Player target = arguments.getPlayer("player");
        String message = arguments.getString("text");
        return this.module.sendPrivateMessage(player, target, message);
    }

    private boolean replyToConversation(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        UUID targetId = this.module.getChatCache(player).getLastConversationWith();
        if (targetId == null) {
            context.send(ChatLang.COMMAND_REPLY_ERROR_EMPTY);
            return false;
        }
        Player target = this.plugin.getServer().getPlayer(targetId);
        if (target == null) {
            context.errorBadPlayer();
            return false;
        }
        String message = arguments.getString("text");
        return this.module.sendPrivateMessage(player, target, message);
    }

    private boolean toggleConversations(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        String playerName = arguments.getString("player", context.getSender().getName());
        this.userManager.loadByNameAsync(playerName).thenCompose(userOptional -> {
            SunUser user = userOptional.orElse(null);
            if (user == null) {
                context.errorBadPlayer();
                return CompletableFuture.completedFuture(null);
            }
            return this.userManager.loadTargetPlayer(user).thenAccept(target -> {
                boolean state = mode.apply(user.getProperty(ChatProperties.CONVERSATIONS));
                user.setProperty(ChatProperties.CONVERSATIONS, state);
                user.markDirty();
                if (context.getSender() != target) {
                    this.module.sendPrefixed(ChatLang.CONVERSATIONS_TOGGLE_FEEDBACK, context.getSender(), builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(state)).with(CommonPlaceholders.PLAYER.resolver(target)));
                }
                if (!context.hasFlag("s")) {
                    this.module.sendPrefixed(ChatLang.CONVERSATIONS_TOGGLE_NOTIFY, (CommandSender)target, builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(state)));
                }
            });
        });
        return true;
    }
}

