/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.channel;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.chat.ChatDefaults;
import su.nightexpress.sunlight.module.chat.channel.ChannelAccessibility;
import su.nightexpress.sunlight.module.chat.channel.ChannelCommand;
import su.nightexpress.sunlight.module.chat.channel.ChannelDisplay;
import su.nightexpress.sunlight.module.chat.channel.ChannelDistance;
import su.nightexpress.sunlight.module.chat.channel.ChannelDistanceType;
import su.nightexpress.sunlight.module.chat.channel.ChannelPrefix;
import su.nightexpress.sunlight.module.chat.channel.ChatChannel;

public class ChannelSchema {
    public static final ConfigProperty<String> NAME = ConfigProperty.of((ConfigType)ConfigTypes.STRING, (String)"Name", (Object)"Channel", (String[])new String[]{"Channel display name."});
    public static final ConfigProperty<String> FORMAT = ConfigProperty.of((ConfigType)ConfigTypes.STRING, (String)"Format", (Object)ChatDefaults.DEFAULT_CHANNEL_FORMAT, (String[])new String[]{"Channel message format.", "[>] Text Formations: %s".formatted("https://nightexpressdev.com/nightcore/configuration/text-formation/"), "[>] %s Support: Yes".formatted("PlaceholderAPI"), "[>] Built-in Placeholders:", "- %format% - User message format from the module's settings.", "- %player_name% - Player name.", "- %player_display_name% - Player display (custom) name.", "- %player_prefix% - Player prefix (from Permissions plugin)", "- %player_suffix% - Player suffix (from Permissions plugin)", "- %player_world% - Player's world name.", "- %channel_id% - Channel unique identifier.", "- %channel_name% - Channel display name.", "- %channel_radius% - Channel message radius."});
    public static final ConfigProperty<Boolean> AUTO_JOIN = ConfigProperty.of((ConfigType)ConfigTypes.BOOLEAN, (String)"Auto_Join", (Object)true, (String[])new String[]{"If enabled, players will automatically join this channel upon entering the server, provided they have the permissions to read or speak in it."});
    public static final ConfigProperty<Boolean> PERMISSION_TO_LISTEN = ConfigProperty.of((ConfigType)ConfigTypes.BOOLEAN, (String)"Permission_Required.Hear", (Object)false, (String[])new String[]{"If enabled, only players with the channel permission are able to read and join this channel."});
    public static final ConfigProperty<Boolean> PERMISSION_TO_SPEAK = ConfigProperty.of((ConfigType)ConfigTypes.BOOLEAN, (String)"Permission_Required.Speak", (Object)false, (String[])new String[]{"If enabled, only players with the channel permission are able to speak in this channel."});
    public static final ConfigProperty<Integer> MESSAGE_COOLDOWN = ConfigProperty.of((ConfigType)ConfigTypes.INT, (String)"Message_Cooldown", (Object)1, (String[])new String[]{"Sets per-player message cooldown (in seconds) for this channel.", "[>] Set 0 to disable."});
    public static final ConfigProperty<ChannelDistanceType> DISTANCE_TYPE = ConfigProperty.of((ConfigType)ConfigTypes.forEnum(ChannelDistanceType.class), (String)"Distance.Type", (Object)((Object)ChannelDistanceType.SERVER_WIDE), (String[])new String[]{"Channel distance mode.", "[>] Available Values: [ %s ]".formatted(Enums.inline(ChannelDistanceType.class))});
    public static final ConfigProperty<Double> DISTANCE_RANGE = ConfigProperty.of((ConfigType)ConfigTypes.DOUBLE, (String)"Distance.Range", (Object)-1.0, (String[])new String[]{"Sets the hearing distance (in blocks) within which players will be able to see each other's messages.", "[*] Useful for the '%s' distance mode only.".formatted(ChannelDistanceType.RANGE.name())});
    public static final ConfigProperty<Boolean> COMMAND_ENABLED = ConfigProperty.of((ConfigType)ConfigTypes.BOOLEAN, (String)"Command.Enabled", (Object)true, (String[])new String[]{"If enabled, adds a dedicated one-shot channel command for players to join the channel."});
    public static final ConfigProperty<String> COMMAND_ALIAS = ConfigProperty.of((ConfigType)ConfigTypes.STRING, (String)"Command.Alias", (Object)"", (String[])new String[]{"Channel command alias."});
    public static final ConfigProperty<Boolean> PREFIX_ENABLED = ConfigProperty.of((ConfigType)ConfigTypes.BOOLEAN, (String)"Prefix.Enabled", (Object)true, (String[])new String[]{"If enabled, players can send messages to this channel by adding the channel prefix to the beginning of their message."});
    public static final ConfigProperty<String> PREFIX_VALUE = ConfigProperty.of((ConfigType)ConfigTypes.STRING, (String)"Prefix.Value", (Object)"", (String[])new String[]{"Channel message prefix."});

    @NotNull
    public static List<ChatChannel> getDefaultChannels() {
        ArrayList<ChatChannel> channels = new ArrayList<ChatChannel>();
        channels.add(ChatChannel.create("local", new ChannelDisplay(TagWrappers.SOFT_AQUA.wrap("Local"), ChatDefaults.DEFAULT_CHANNEL_FORMAT), new ChannelAccessibility(true, false, false, 1), new ChannelDistance(ChannelDistanceType.RANGE, 100.0), new ChannelCommand(true, "localchat"), new ChannelPrefix(true, ":")));
        channels.add(ChatChannel.create("world", new ChannelDisplay(TagWrappers.ORANGE.wrap("World"), ChatDefaults.DEFAULT_CHANNEL_FORMAT), new ChannelAccessibility(true, false, false, 3), new ChannelDistance(ChannelDistanceType.WORLD_WIDE, -1.0), new ChannelCommand(true, "worldchat"), new ChannelPrefix(true, ".")));
        channels.add(ChatChannel.create("global", new ChannelDisplay(TagWrappers.ORANGE.wrap("Global"), ChatDefaults.DEFAULT_CHANNEL_FORMAT), new ChannelAccessibility(true, false, false, 3), new ChannelDistance(ChannelDistanceType.SERVER_WIDE, -1.0), new ChannelCommand(true, "globalchat"), new ChannelPrefix(true, "!")));
        channels.add(ChatChannel.create("trade", new ChannelDisplay(TagWrappers.GREEN.wrap("Trade"), ChatDefaults.DEFAULT_CHANNEL_FORMAT), new ChannelAccessibility(true, false, true, 30), new ChannelDistance(ChannelDistanceType.SERVER_WIDE, -1.0), new ChannelCommand(true, "tradechat"), new ChannelPrefix(true, "$")));
        channels.add(ChatChannel.create("staff", new ChannelDisplay(TagWrappers.SOFT_RED.wrap("Staff"), ChatDefaults.DEFAULT_CHANNEL_FORMAT), new ChannelAccessibility(true, true, true, 0), new ChannelDistance(ChannelDistanceType.SERVER_WIDE, -1.0), new ChannelCommand(true, "staffchat"), new ChannelPrefix(true, "#")));
        return channels;
    }

    @NotNull
    public static ChatChannel createDefaultChannel() {
        return ChatChannel.create("_default_", new ChannelDisplay(TagWrappers.WHITE.wrap("Default"), "%format%"), new ChannelAccessibility(true, false, false, 0), new ChannelDistance(ChannelDistanceType.SERVER_WIDE, -1.0), new ChannelCommand(false, ""), new ChannelPrefix(false, ""));
    }
}

