/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bukkit.Sound;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.wrap.NightSound;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.CommandUtil;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.chat.ChatDefaults;
import su.nightexpress.sunlight.module.chat.format.FormatComponent;
import su.nightexpress.sunlight.module.chat.format.FormatDefinition;
import su.nightexpress.sunlight.module.chat.mention.GroupMention;
import su.nightexpress.sunlight.module.chat.spy.SpyType;

public class ChatSettings
extends AbstractConfig {
    private static final ConfigType<FormatComponent> FORMAT_COMPONENT_CONFIG_TYPE = ConfigType.of(FormatComponent::read, FileConfig::set);
    private static final ConfigType<FormatDefinition> FORMAT_DEFINITION_CONFIG_TYPE = ConfigType.of(FormatDefinition::read, FileConfig::set);
    private static final ConfigType<GroupMention> GROUP_MENTION_CONFIG_TYPE = ConfigType.of(GroupMention::read, FileConfig::set);
    private final ConfigProperty<EventPriority> chatEventPriority = this.addProperty(ConfigTypes.forEnum(EventPriority.class), "Global.Chat-Event-Priority", EventPriority.HIGH, new String[]{"Sets priority for the AsyncChatEvent (Paper) / AsyncPlayerChatEvent (Spigot) handler.", "[>] Available values: [" + Enums.inline(EventPriority.class) + "]", "[*] Do not touch unless you're experiencing compatibility issues or you know what you're doing."});
    private final ConfigProperty<Boolean> discordHookEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Global.DiscordSRV.Enabled", true, new String[]{"Enables %s integration.".formatted("DiscordSRV"), "[*] Experimental. Currently supports only Game -> Discord messages."});
    private final ConfigProperty<Boolean> disableReports = this.addProperty(ConfigTypes.BOOLEAN, "Global.Disable-Chat-Reports", true, new String[]{"Disables the Chat Reports system and verification messages on join."});
    private final ConfigProperty<Boolean> roleplayEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Roleplay-Commands.Enabled", true, new String[]{"Adds a few roleplay-like commands if enabled."});
    private final ConfigProperty<String> roleplayMeFormat = this.addProperty(ConfigTypes.STRING, "Roleplay-Commands.Me.Format", TagWrappers.ITALIC.wrap(TagWrappers.SOFT_AQUA.wrap("%player_display_name%") + " " + TagWrappers.GRAY.wrap("%message%")), new String[]{"Format for the /me command."});
    private final ConfigProperty<Map<String, FormatComponent>> formatComponents = this.addProperty(ConfigTypes.forMapWithLowerKeys(FORMAT_COMPONENT_CONFIG_TYPE), "Chat.Format.Components", ChatDefaults.getDefaultFormatComponents(), new String[]{"Here you can create custom 'components' to use in the user formats below.", "To insert a component into user format, wrap it into '%' brackets: %my_component%", "[>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "[>] %s Support: Yes".formatted("PlaceholderAPI"), "[>] Built-in Placeholders:", "- %message% - Original message sent by a player.", "- %player_name% - Player name.", "- %player_display_name% - Player display (custom) name.", "- %player_prefix% - Player prefix (from Permissions plugin)", "- %player_suffix% - Player suffix (from Permissions plugin)", "- %player_world% - Player's world name."});
    private final ConfigProperty<Map<String, FormatDefinition>> formatDefinitions = this.addProperty(ConfigTypes.forMapWithLowerKeys(FORMAT_DEFINITION_CONFIG_TYPE), "Chat.Format.User", ChatDefaults.getDefaultFormats(), new String[]{"Here you can create custom chat formats for players based on their permission group(s).", "[>] Options:", "    - Priority: If multiple formats available, the one with the greatest priority is used.", "    - Format: Chat message format. For a list of placeholders, please see the 'Format.Components' section above.", "    - Ranks: List of ranks (permission group names) to which this format is applicable. Add '%s' to allow any rank.".formatted("*"), "[>] If no format is available for a player, fallbacks to the 'Format.Fallback' setting."});
    private final ConfigProperty<String> formatFallback = this.addProperty(ConfigTypes.STRING, "Chat.Format.Fallback", "%player_name%: %message%", new String[]{"Fallback chat message format used when no other format is available for a player.", "[*] Please don't rely much on this setting, instead ensure to setup your user formats properly."});
    private final ConfigProperty<Boolean> channelsEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Channels.Enabled", true, new String[]{"Enables the Channels feature.", "This allows you to create multiple chat channels with different formats, permissions, message cooldowns, etc.", "[*] When disabled, the chat fallbacks to the %s channel inside the %s directory and no other channel features are available to use.".formatted("_default_", "/channels/")});
    private final ConfigProperty<String> channelsDefaultId = this.addProperty(ConfigTypes.STRING, "Channels.Default-Channel-Id", "local", new String[]{"Sets which channel used by default for all player messages.", "[*] If invalid channel provided, fallbacks to the %s channel.".formatted("_default_")});
    private final ConfigProperty<Boolean> conversationEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Conversations.Enabled", true, new String[]{"Enables the Conversations feature allowing players to send private messages to each other."});
    private final ConfigProperty<Boolean> conversationSoundEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Conversations.Sound.Enabled", true, new String[]{"If enabled, a sound will play whenever a player receives or sends a private message."});
    private final ConfigProperty<NightSound> conversationSoundIncoming = this.addProperty(ConfigTypes.NIGHT_SOUND, "Conversations.Sound.Incoming", VanillaSound.of((Sound)Sound.BLOCK_NOTE_BLOCK_BELL), new String[]{"Sound for incoming private messages."});
    private final ConfigProperty<NightSound> conversationSoundOutgoing = this.addProperty(ConfigTypes.NIGHT_SOUND, "Conversations.Sound.Outgoing", VanillaSound.of((Sound)Sound.UI_BUTTON_CLICK), new String[]{"Sound for outgoing private messages."});
    private final ConfigProperty<String> conversationProxyFormat = this.addProperty(ConfigTypes.STRING, "Conversations.Format.Basic", "%message%", new String[]{"Conversation message format used in 'Incoming' and 'Outgoing' formats below.", "[>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "[>] %s Support: Yes".formatted("PlaceholderAPI"), "[>] Built-in Placeholders:", "- %message% - Original message sent by a player.", "- %player_name% - Player name.", "- %player_display_name% - Player display (custom) name.", "- %player_prefix% - Player prefix (from Permissions plugin)", "- %player_suffix% - Player suffix (from Permissions plugin)", "- %player_world% - Player's world name."});
    private final ConfigProperty<String> conversationIncomingFormat = this.addProperty(ConfigTypes.STRING, "Conversations.Format.Incoming", TagWrappers.LIGHT_PURPLE.wrap("[Whisper]") + " " + TagWrappers.SOFT_PINK.wrap("%player_display_name%: ") + TagWrappers.GRAY.wrap("%format%") + " " + ((SimpleTagWrapper)TagWrappers.SUGGEST_COMMAND.with("/msg %player_name%")).wrap(((SimpleTagWrapper)TagWrappers.SHOW_TEXT.with(TagWrappers.LIGHT_PURPLE.wrap("Click to reply!"))).wrap(TagWrappers.LIGHT_PURPLE.wrap("[\u2b05]"))), new String[]{"Format for incoming private messages.", "[>] Use the %s placeholder to insert 'basic' conversation format from the 'Format.Basic' section above".formatted("%format%"), "[*] For a list of placeholders, please see the 'Format.Basic' section above."});
    private final ConfigProperty<String> conversationOutgoingFormat = this.addProperty(ConfigTypes.STRING, "Conversations.Format.Outgoing", TagWrappers.LIGHT_PURPLE.wrap("[Whisper]") + " " + TagWrappers.SOFT_PINK.wrap("You \u27a1 %player_display_name%: ") + TagWrappers.GRAY.wrap("%format%"), new String[]{"Format for outgoing private messages.", "[>] Use the %s placeholder to insert 'basic' conversation format from the 'Format.Basic' section above".formatted("%format%"), "[*] For a list of placeholders, please see the 'Format.Basic' section above."});
    private final ConfigProperty<Boolean> mentionsEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Mentions.Enabled", true, new String[]{"If enabled, this allows players to mention (tag) other players or entire groups in the chat."});
    private final ConfigValue<Integer> mentionsLimit = ConfigValue.create((String)"Mentions.Limit-Per-Message", (int)3, (String[])new String[]{"This sets the maximum number of mentions (tags) allowed per message. Any additional mentions beyond this limit will not have any effect.", "[>] Set -1 for no limits."});
    private final ConfigValue<Integer> mentionsCooldown = ConfigValue.create((String)"Mentions.Cooldown-Per-Mention", (int)15, (String[])new String[]{"Sets the cooldown time for each mention (tag).", "[>] Set -1 for to disable."});
    private final ConfigProperty<String> mentionsPattern = this.addProperty(ConfigTypes.STRING, "Mentions.Prefix", "@(\\w+)", new String[]{"The regex pattern used to identify mentions (tags) in a player's message. By default, this is @Something."});
    private final ConfigProperty<String> mentionsFormat = this.addProperty(ConfigTypes.STRING, "Mentions.Player.Format", TagWrappers.SOFT_GREEN.wrap("@%player_display_name%"), new String[]{"Format for player mentions.", "[>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "[>] Built-in Placeholders:", "- %player_name% - Player name.", "- %player_display_name% - Player display (custom) name.", "- %player_prefix% - Player prefix (from Permissions plugin)", "- %player_suffix% - Player suffix (from Permissions plugin)", "- %player_world% - Player's world name."});
    private final ConfigProperty<Map<String, GroupMention>> mentionsCustoms = this.addProperty(ConfigTypes.forMap(GROUP_MENTION_CONFIG_TYPE), "Mentions.Special", ChatDefaults.getDefaultMentions(), new String[]{"Here you can create custom mentions that affects all players with certain ranks (permission groups).", "[>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "[>] Options:", "    - Format: Mention format.", "    - Ranks: List of ranks (permission group names) to which this mention is applicable. Add '%s' to allow any rank.".formatted("*")});
    private final ConfigProperty<Integer> autoModerationUserCacheLifetime = this.addProperty(ConfigTypes.INT, "AutoModeration.UserCache.Life-Time", 60, new String[]{"Sets cache lifetime (in seconds) for user content tracked by the Auto-Moderation feature.", "[>] This includes:", "- Latest message sent with timestamp.", "- Latest command used with timestamp.", "[*] Disabling the cache will break some of Auto-Moderation features (e.g. Anti-Flood)."});
    private final ConfigProperty<Boolean> antiCapsEnabled = this.addProperty(ConfigTypes.BOOLEAN, "AutoModeration.Anti-Caps.Enabled", true, new String[]{"This feature forces a player's message to lowercase if the number of uppercase characters exceeds the specified threshold."});
    private final ConfigProperty<Integer> antiCapsLengthThreshold = this.addProperty(ConfigTypes.INT, "AutoModeration.Anti-Caps.Min-Message-Length", 5, new String[]{"The minimum message length required for the Anti-Caps feature to trigger."});
    private final ConfigProperty<Integer> antiCapsUpperCaseThreshold = this.addProperty(ConfigTypes.INT, "AutoModeration.Anti-Caps.Uppercase-Threshold", 70, new String[]{"The minimum threshold (in %) of uppercase characters in a message required for the Anti-Caps feature to trigger."});
    private final ConfigProperty<Set<String>> antiCapsAffectedCommands = this.addProperty(ConfigTypes.STRING_SET_LOWER_CASE, "AutoModeration.Anti-Caps.Affected-Commands", Set.of("tell", "me", "reply", "broadcast"), new String[]{"List of commands for which the Anti-Caps feature will be active."});
    private final ConfigProperty<Boolean> antiFloodEnabled = this.addProperty(ConfigTypes.BOOLEAN, "AutoModeration.Anti-Flood.Enabled", true, new String[]{"This feature prevents players from sending the same (or very similar) messages and commands within a (very) short period of time."});
    private final ConfigProperty<Double> antiFloodSimilarityScoreThreshold = this.addProperty(ConfigTypes.DOUBLE, "AutoModeration.Anti-Flood.Similarity.Score-Threshold", 80.0, new String[]{"The similarity trigger threshold (in %) for the Anti-Flood feature regarding messages and commands.", "If the similarity percentage between a player's last message/command and the one they are trying to send meets or exceeds this value, the message will be blocked."});
    private final ConfigProperty<Integer> antiFloodSimilarityCountThreshold = this.addProperty(ConfigTypes.INT, "AutoModeration.Anti-Flood.Similarity.Count-Threshold", 3, new String[]{"The quantitative trigger threshold for the Anti-Flood feature for messages and commands", "If a player sends this specific number of similar messages or commands in a row within the time specified in 'UserCache.Life-Time', further similar messages will be blocked until the cache expires."});
    private final ConfigProperty<Long> antiFloodCommandCooldown = this.addProperty(ConfigTypes.LONG, "AutoModeration.Anti-Flood.Commands.Cooldown", 500L, new String[]{"Sets global cooldown (in milliseconds) on command usage..", "[Default is 500ms (0.5s)]"});
    private final ConfigProperty<Set<String>> antiFloodCommandWhitelist = this.addProperty(ConfigTypes.STRING_SET_LOWER_CASE, "AutoModeration.Anti-Flood.Command-Whitelist", Set.of("tell", "reply", "spawn", "home", "warp", "sethome", "delhome", "kit"), new String[]{"List of commands excluded from the Anti-Flood feature, so players can use them without all the Anti-Flood checks and restrictions."});
    private final ConfigProperty<Boolean> profanityFilterEnabled = this.addProperty(ConfigTypes.BOOLEAN, "AutoModeration.Profanity-Filter.Enabled", true, new String[]{"This feature enables a filter for profanity (or any specified words) in messages and commands."});
    private final ConfigProperty<Set<String>> profanityFilterRules = this.addProperty(ConfigTypes.STRING_SET_LOWER_CASE, "AutoModeration.Profanity-Filter.Rules", Set.of("default.txt"), new String[]{"The list of rule files for the Profanity Filter.", "[>] Rule files are stored in the %s folder.".formatted("/rules/"), "[>] You can create your own files or modify existing ones."});
    private final ConfigProperty<Set<String>> profanityFilterAffectedCommands = this.addProperty(ConfigTypes.STRING_SET_LOWER_CASE, "AutoModeration.Profanity-Filter.Affected-Commands", Set.of("tell", "me", "reply", "broadcast"), new String[]{"List of commands for which the Profanity-Filter feature will be active."});
    private final ConfigProperty<Boolean> itemShowEnabled = this.addProperty(ConfigTypes.BOOLEAN, "ItemShow.Enabled", true, new String[]{"This feature allows players to use a placeholder to display the item they are currently holding in the chat."});
    private final ConfigProperty<String> itemShowPlaceholder = this.addProperty(ConfigTypes.STRING, "ItemShow.Placeholder", "@hand", new String[]{"The placeholder used to display item in chat."});
    private final ConfigProperty<String> itemShowFormat = this.addProperty(ConfigTypes.STRING, "ItemShow.Format", TagWrappers.GRAY.wrap("<" + TagWrappers.WHITE.wrap(((SimpleTagWrapper)TagWrappers.SHOW_ITEM.with("%item_value%")).wrap("%item_name%")) + ">"), new String[]{"Item display format.", "[>] Text Formations: %s".formatted("https://nightexpressdev.com/nightcore/configuration/text-formation/"), "[>] Placeholders:", "- %s - Item display name.".formatted("%item_name%"), "- %s - Item NBT Tag (in Base64).".formatted("%item_value%")});
    private final ConfigProperty<Boolean> spyEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Spy.Enabled", true, new String[]{"This feature allows you to monitor player's chat messages, used commands and conversations."});
    private final ConfigProperty<Map<SpyType, String>> spyFormat = this.addProperty(ConfigTypes.forMap(string -> (SpyType)Enums.get((String)string, SpyType.class), Enum::name, (ConfigType)ConfigTypes.STRING), "Spy.Info-Format", ChatDefaults.getDefaultSpyFormat(), new String[]{"Format for Spy Modes.", "[>] Text Formations: %s".formatted("https://nightexpressdev.com/nightcore/configuration/text-formation/"), "[>] Placeholders:", "- %s - Player message/command.".formatted("%message%"), "- %s - Target player name (for %s mode only).".formatted("%target%", SpyType.SOCIAL.name()), "- %s - Channel name (for %s mode only).".formatted("%channel_name%", SpyType.CHAT.name()), "- %player_name% - Player name.", "- %player_display_name% - Player display (custom) name.", "- %player_prefix% - Player prefix (from Permissions plugin)", "- %player_suffix% - Player suffix (from Permissions plugin)", "- %player_world% - Player's world name."});

    @NotNull
    public EventPriority getChatEventPriority() {
        return (EventPriority)this.chatEventPriority.get();
    }

    public boolean getReportsDisable() {
        return (Boolean)this.disableReports.get();
    }

    public boolean isDiscordHookEnabled() {
        return (Boolean)this.discordHookEnabled.get();
    }

    public int getUserContentCacheLifetime() {
        return (Integer)this.autoModerationUserCacheLifetime.get();
    }

    public boolean isRoleplayCommandEnabled() {
        return (Boolean)this.roleplayEnabled.get();
    }

    @NotNull
    public String getRoleplayMeFormat() {
        return (String)this.roleplayMeFormat.get();
    }

    @NotNull
    public Map<String, FormatComponent> getFormatComponents() {
        return (Map)this.formatComponents.get();
    }

    @NotNull
    public Map<String, FormatDefinition> getFormatDefinitions() {
        return (Map)this.formatDefinitions.get();
    }

    @NotNull
    public String getFormatFallback() {
        return (String)this.formatFallback.get();
    }

    public boolean isChannelsEnabled() {
        return (Boolean)this.channelsEnabled.get();
    }

    @NotNull
    public String getChannelDefaultId() {
        return (String)this.channelsDefaultId.get();
    }

    public boolean isAntiCapsEnabled() {
        return (Boolean)this.antiCapsEnabled.get();
    }

    public int getAntiCapsLengthThreshold() {
        return (Integer)this.antiCapsLengthThreshold.get();
    }

    public int getAntiCapsUpperCaseThreshold() {
        return (Integer)this.antiCapsUpperCaseThreshold.get();
    }

    public boolean isAntiCapsBlacklistedCommand(@NotNull String command) {
        return this.isCommandInList(command, (Collection)this.antiCapsAffectedCommands.get());
    }

    public boolean isAntiFloodEnabled() {
        return (Boolean)this.antiFloodEnabled.get();
    }

    public double getAntiFloodSimilarityScoreThreshold() {
        return (Double)this.antiFloodSimilarityScoreThreshold.get();
    }

    public int getAntiFloodSimilarityCountThreshold() {
        return (Integer)this.antiFloodSimilarityCountThreshold.get();
    }

    public long getAntiFloodCommandCooldown() {
        return (Long)this.antiFloodCommandCooldown.get();
    }

    public boolean isAntiFloodWhitelistedCommand(@NotNull String command) {
        return this.isCommandInList(command, (Collection)this.antiFloodCommandWhitelist.get());
    }

    public boolean getProfanityFilterEnabled() {
        return (Boolean)this.profanityFilterEnabled.get();
    }

    @NotNull
    public Set<String> getProfanityFilterRules() {
        return (Set)this.profanityFilterRules.get();
    }

    public boolean isConversationsEnabled() {
        return (Boolean)this.conversationEnabled.get();
    }

    @NotNull
    public String getConversationProxyFormat() {
        return (String)this.conversationProxyFormat.get();
    }

    @NotNull
    public String getConversationIncomingFormat() {
        return (String)this.conversationIncomingFormat.get();
    }

    @NotNull
    public String getConversationOutgoingFormat() {
        return (String)this.conversationOutgoingFormat.get();
    }

    public boolean isConversationSoundsEnabled() {
        return (Boolean)this.conversationSoundEnabled.get();
    }

    @NotNull
    public NightSound getConversationIncomingSound() {
        return (NightSound)this.conversationSoundIncoming.get();
    }

    @NotNull
    public NightSound getConversationOutgoingSound() {
        return (NightSound)this.conversationSoundOutgoing.get();
    }

    public boolean isMentionsEnabled() {
        return (Boolean)this.mentionsEnabled.get();
    }

    @NotNull
    public String getMentionsPattern() {
        return (String)this.mentionsPattern.get();
    }

    public int getMentionsLimit() {
        return (Integer)this.mentionsLimit.get();
    }

    public int getMentionsCooldown() {
        return (Integer)this.mentionsCooldown.get();
    }

    @NotNull
    public String getMentionsFormat() {
        return (String)this.mentionsFormat.get();
    }

    @NotNull
    public Map<String, GroupMention> getCustomMentions() {
        return (Map)this.mentionsCustoms.get();
    }

    public boolean isItemShowEnabled() {
        return (Boolean)this.itemShowEnabled.get();
    }

    @NotNull
    public String getItemShowPlaceholder() {
        return (String)this.itemShowPlaceholder.get();
    }

    @NotNull
    public String getItemShowFormat() {
        return (String)this.itemShowFormat.get();
    }

    public boolean isSpyEnabled() {
        return (Boolean)this.spyEnabled.get();
    }

    @Nullable
    public String getSpyModeFormat(@NotNull SpyType type) {
        return (String)((Map)this.spyFormat.get()).get((Object)type);
    }

    public boolean isProfanityFilterAffectedCommand(@NotNull String command) {
        return this.isCommandInList(command, (Collection)this.profanityFilterAffectedCommands.get());
    }

    private boolean isCommandInList(@NotNull String command, @NotNull Collection<String> collection) {
        return CommandUtil.getAliases((String)command, (boolean)true).stream().anyMatch(collection::contains);
    }
}

