/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEvent;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEventHandler;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.HookId;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.chat.ChatDefaults;
import su.nightexpress.sunlight.module.chat.ChatLang;
import su.nightexpress.sunlight.module.chat.ChatPerms;
import su.nightexpress.sunlight.module.chat.ChatProperties;
import su.nightexpress.sunlight.module.chat.ChatSettings;
import su.nightexpress.sunlight.module.chat.cache.UserChatCache;
import su.nightexpress.sunlight.module.chat.channel.ChannelRepository;
import su.nightexpress.sunlight.module.chat.channel.ChannelSchema;
import su.nightexpress.sunlight.module.chat.channel.ChatChannel;
import su.nightexpress.sunlight.module.chat.command.ChannelCommandsProvider;
import su.nightexpress.sunlight.module.chat.command.ClearChatCommandProvider;
import su.nightexpress.sunlight.module.chat.command.ConversationCommandProvider;
import su.nightexpress.sunlight.module.chat.command.MentionsCommandProvider;
import su.nightexpress.sunlight.module.chat.command.RoleplayCommands;
import su.nightexpress.sunlight.module.chat.command.SpyCommandProvider;
import su.nightexpress.sunlight.module.chat.context.ChatContext;
import su.nightexpress.sunlight.module.chat.context.CommandContext;
import su.nightexpress.sunlight.module.chat.context.ConversationContext;
import su.nightexpress.sunlight.module.chat.context.MessageContext;
import su.nightexpress.sunlight.module.chat.discord.DiscordHandler;
import su.nightexpress.sunlight.module.chat.event.PlayerPrivateMessageEvent;
import su.nightexpress.sunlight.module.chat.format.FormatDefinition;
import su.nightexpress.sunlight.module.chat.listener.ChatListener;
import su.nightexpress.sunlight.module.chat.processor.ChatProcessor;
import su.nightexpress.sunlight.module.chat.processor.chat.ChannelProcessor;
import su.nightexpress.sunlight.module.chat.processor.chat.DiscordProcessor;
import su.nightexpress.sunlight.module.chat.processor.chat.FormatProcessor;
import su.nightexpress.sunlight.module.chat.processor.chat.MentionProcessor;
import su.nightexpress.sunlight.module.chat.processor.command.CommandCooldownProcessor;
import su.nightexpress.sunlight.module.chat.processor.conversation.ConversationProcessor;
import su.nightexpress.sunlight.module.chat.processor.global.AntiCapsProcessor;
import su.nightexpress.sunlight.module.chat.processor.global.AntiFloodProcessor;
import su.nightexpress.sunlight.module.chat.processor.global.ColorProcessor;
import su.nightexpress.sunlight.module.chat.processor.global.FilterProcessor;
import su.nightexpress.sunlight.module.chat.processor.global.ItemDisplayProcessor;
import su.nightexpress.sunlight.module.chat.processor.global.SpyProcessor;
import su.nightexpress.sunlight.module.chat.report.ReportHandler;
import su.nightexpress.sunlight.module.chat.report.ReportPacketsHandler;
import su.nightexpress.sunlight.module.chat.report.ReportProtocolHandler;
import su.nightexpress.sunlight.module.chat.rule.WordFilter;
import su.nightexpress.sunlight.module.chat.spy.SpyLogger;
import su.nightexpress.sunlight.module.chat.spy.SpyType;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserProperty;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class ChatModule
extends Module {
    private final ChatSettings settings = new ChatSettings();
    private final ChannelRepository channelRepository = new ChannelRepository();
    private final UniversalChatEventHandler chatEventHandler = this::handleChatMessage;
    private Pattern mentionsPattern;
    private WordFilter wordFilter;
    private SpyLogger spyLogger;
    private ReportHandler reportHandler;
    private DiscordHandler discordHandler;

    public ChatModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        ((SunLightPlugin)this.plugin).injectLang(ChatLang.class);
        this.settings.load(config);
        this.loadMentions();
        this.loadConversations();
        this.loadChannels();
        this.loadWordFilter();
        this.loadSpy();
        this.loadReportHandler();
        this.loadDiscordHook();
        ((SunLightPlugin)this.plugin).addChatHandler(this.settings.getChatEventPriority(), this.chatEventHandler);
        ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers().forEach(this::autoJoinChannels);
        this.addListener((SimpeListener)new ChatListener((SunLightPlugin)this.plugin, this));
    }

    @Override
    protected void unloadModule() {
        ((SunLightPlugin)this.plugin).removeChatHandler(this.chatEventHandler);
        this.channelRepository.clear();
        this.wordFilter = null;
        if (this.spyLogger != null) {
            this.spyLogger.write();
            this.spyLogger.shutdown();
            this.spyLogger = null;
        }
        if (this.discordHandler != null) {
            this.discordHandler.shutdown();
            this.discordHandler = null;
        }
        if (this.reportHandler != null) {
            this.reportHandler.unload();
            this.reportHandler = null;
        }
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        this.channelRepository.getChannels().forEach(channel -> {
            ChatPerms.CHANNEL_LISTEN.permission(channel.getId());
            ChatPerms.CHANNEL_SPEAK.permission(channel.getId());
        });
        root.merge(ChatPerms.ROOT);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("chat-clearchat", new ClearChatCommandProvider((SunLightPlugin)this.plugin, this));
        if (this.settings.isChannelsEnabled()) {
            this.commandRegistry.addProvider("chat-channel", new ChannelCommandsProvider((SunLightPlugin)this.plugin, this));
        }
        if (this.settings.isConversationsEnabled()) {
            this.commandRegistry.addProvider("chat-conversations", new ConversationCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        }
        if (this.settings.isMentionsEnabled()) {
            this.commandRegistry.addProvider("chat-mentions", new MentionsCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        }
        if (this.settings.isRoleplayCommandEnabled()) {
            this.commandRegistry.addProvider("chat-roleplay", new RoleplayCommands((SunLightPlugin)this.plugin, this));
        }
        if (this.settings.isSpyEnabled()) {
            this.commandRegistry.addProvider("chat-spy", new SpyCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        }
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    private void loadMentions() {
        if (!this.settings.isMentionsEnabled()) {
            return;
        }
        UserPropertyRegistry.register(ChatProperties.MENTIONS);
        this.mentionsPattern = Pattern.compile(this.settings.getMentionsPattern());
        this.settings.getCustomMentions().forEach((id, groupMention) -> ChatPerms.MENTION.permission((String)id));
    }

    private void loadConversations() {
        if (!this.settings.isConversationsEnabled()) {
            return;
        }
        UserPropertyRegistry.register(ChatProperties.CONVERSATIONS);
    }

    private void loadChannels() {
        Path channelsDir = Path.of(this.getSystemPath() + "/channels/", new String[0]);
        if (!this.settings.isChannelsEnabled()) {
            this.loadDefaultChannel(channelsDir);
            return;
        }
        if (!Files.exists(channelsDir, new LinkOption[0])) {
            ChannelSchema.getDefaultChannels().forEach(channel -> this.writeChannel(channelsDir, (ChatChannel)channel));
        }
        FileUtil.findYamlFiles((String)channelsDir.toString()).forEach(this::loadChannel);
        String defaultId = this.settings.getChannelDefaultId();
        ChatChannel defChannel = this.channelRepository.getById(defaultId);
        if (defChannel == null) {
            this.error("Channel '%s', that is set as default one, does not exist. The '%s' one will be used to keep the chat working.".formatted(defaultId, "_default_"));
            this.loadDefaultChannel(channelsDir);
            return;
        }
        this.channelRepository.setDefaultChannel(defChannel);
    }

    private void writeChannel(@NotNull Path channelsDir, @NotNull ChatChannel channel) {
        Path file = Path.of(channelsDir.toString(), FileConfig.withExtension((String)channel.getId()));
        FileConfig config = FileConfig.load((Path)file);
        config.edit(channel::write);
    }

    @NotNull
    private ChatChannel loadChannel(@NotNull Path channelFile) {
        ChatChannel channel = ChatChannel.fromFile(channelFile);
        this.channelRepository.add(channel);
        return channel;
    }

    private void loadDefaultChannel(@NotNull Path channelsDir) {
        Path defFile = Path.of(channelsDir.toString(), FileConfig.withExtension((String)"_default_"));
        if (!Files.exists(defFile, new LinkOption[0])) {
            this.writeChannel(channelsDir, ChannelSchema.createDefaultChannel());
        }
        ChatChannel channel = this.loadChannel(defFile);
        this.channelRepository.setDefaultChannel(channel);
    }

    private void loadWordFilter() {
        if (!this.settings.getProfanityFilterEnabled()) {
            return;
        }
        Path rulesPath = Path.of(this.getSystemPath() + "/rules/", new String[0]);
        if (!Files.exists(rulesPath, new LinkOption[0])) {
            try {
                Files.createDirectories(rulesPath, new FileAttribute[0]);
                Collection<String> defaultRules = ChatDefaults.getDefaultWordFilterRules(Locale.getDefault());
                if (!defaultRules.isEmpty()) {
                    this.writeRules(defaultRules, Path.of(rulesPath.toString(), "default.txt"));
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return;
            }
        }
        Set<String> ruleNames = this.settings.getProfanityFilterRules();
        HashSet<String> allRules = new HashSet<String>();
        FileUtil.findFiles((String)rulesPath.toString(), file -> ruleNames.contains(file.getFileName().toString())).forEach(file -> allRules.addAll(this.readRules((Path)file)));
        this.wordFilter = new WordFilter(allRules);
    }

    private void writeRules(@NotNull Collection<String> rules, @NotNull Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String rule : rules) {
                writer.append(rule);
                writer.newLine();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @NotNull
    private Collection<String> readRules(@NotNull Path file) {
        HashSet<String> rules = new HashSet<String>();
        try (Stream<String> stream = Files.lines(file);){
            stream.filter(Predicate.not(String::isBlank)).forEach(rules::add);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return rules;
    }

    private void loadSpy() {
        if (!this.settings.isSpyEnabled()) {
            return;
        }
        for (SpyType spyType : SpyType.values()) {
            UserPropertyRegistry.register(ChatProperties.getSpyInfoProperty(spyType));
            UserPropertyRegistry.register(ChatProperties.getSpyLogProperty(spyType));
        }
        try {
            this.spyLogger = new SpyLogger((SunLightPlugin)this.plugin, Path.of(this.getSystemPath(), "spy.log"));
            this.addAsyncTask(this.spyLogger::write, 60);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void loadReportHandler() {
        if (this.settings.getReportsDisable()) {
            if (Plugins.isInstalled((String)"packetevents")) {
                this.reportHandler = new ReportPacketsHandler();
            } else if (Plugins.isInstalled((String)"ProtocolLib")) {
                this.reportHandler = new ReportProtocolHandler((SunLightPlugin)this.plugin);
            }
            if (this.reportHandler != null) {
                this.reportHandler.load();
            }
        }
    }

    private void loadDiscordHook() {
        if (this.settings.isDiscordHookEnabled() && HookId.hasDiscordSRV()) {
            this.discordHandler = new DiscordHandler((SunLightPlugin)this.plugin, this);
            this.discordHandler.setup();
        }
    }

    @NotNull
    public ChatSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public UserChatCache getChatCache(@NotNull Player player) {
        return ((SunUser)this.userManager.getOrFetch(player)).getCacheOrCreate(UserChatCache.class, UserChatCache::new);
    }

    @NotNull
    public ChannelRepository getChannelRepository() {
        return this.channelRepository;
    }

    @Nullable
    public DiscordHandler getDiscordHandler() {
        return this.discordHandler;
    }

    @NotNull
    public Set<ChatChannel> getChannelsAllowedToListen(@NotNull Player player) {
        return this.channelRepository.getChannels().stream().filter(channel -> channel.canListenHere(player)).collect(Collectors.toSet());
    }

    @NotNull
    public String getEffectiveChatFormat(@NotNull Player player) {
        return this.settings.getFormatDefinitions().values().stream().filter(container -> container.isApplicable(player)).max(Comparator.comparingInt(FormatDefinition::getPriority)).map(FormatDefinition::getFormat).orElse(this.settings.getFormatFallback());
    }

    @NotNull
    public ChatChannel getEffectiveChannel(@NotNull Player player, @Nullable Character prefix) {
        ChatChannel byPrefix;
        if (prefix != null && (byPrefix = this.channelRepository.getByPrefix(prefix.charValue())) != null && byPrefix.canSpeakHere(player)) {
            return byPrefix;
        }
        return this.channelRepository.getDefaultChannel();
    }

    public boolean joinChannel(@NotNull Player player, @NotNull ChatChannel channel) {
        return this.joinChannel(player, channel, false);
    }

    public boolean joinChannel(@NotNull Player player, @NotNull ChatChannel channel, boolean isSilent) {
        if (!channel.canListenOrSpeakHere(player)) {
            if (!isSilent) {
                this.sendPrefixed(ChatLang.CHANNEL_JOIN_ERROR_NO_PERMISSION, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(channel.placeholders()));
            }
            return false;
        }
        if (channel.addPlayer(player)) {
            if (!isSilent) {
                this.sendPrefixed(ChatLang.CHANNEL_JOIN_SUCCESS, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(channel.placeholders()));
            }
            return true;
        }
        if (!isSilent) {
            this.sendPrefixed(ChatLang.CHANNEL_JOIN_ERROR_ALREADY_IN, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(channel.placeholders()));
        }
        return false;
    }

    public boolean leaveChannel(@NotNull Player player, @NotNull ChatChannel channel) {
        if (channel.removePlayer(player)) {
            this.sendPrefixed(ChatLang.CHANNEL_LEAVE_SUCCESS, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(channel.placeholders()));
            return true;
        }
        this.sendPrefixed(ChatLang.CHANNEL_LEAVE_ERROR_NOT_IN, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(channel.placeholders()));
        return false;
    }

    public void autoJoinChannels(@NotNull Player player) {
        this.getChannelsAllowedToListen(player).stream().filter(channel -> channel.getAccessibility().autoJoin()).forEach(channel -> this.joinChannel(player, (ChatChannel)channel, true));
    }

    public void removeFromAllChannels(@NotNull Player player) {
        this.channelRepository.getChannels().forEach(channel -> channel.removePlayer(player));
    }

    @NotNull
    public Set<Player> getSpies(@NotNull SpyType type) {
        UserProperty<Boolean> property = ChatProperties.getSpyInfoProperty(type);
        return ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers().stream().filter(player -> (Boolean)((SunUser)this.userManager.getOrFetch((Player)player)).getProperty(property)).collect(Collectors.toSet());
    }

    public void sendSpyInfo(@NotNull Player player, @NotNull String message, @NotNull String format, @NotNull SpyType spyType) {
        PlaceholderContext context = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)player)).with("%message%", () -> message).build();
        String formatted = context.apply(format);
        this.getSpies(spyType).forEach(spy -> Players.sendMessage((CommandSender)spy, (String)formatted));
        SunUser user = (SunUser)this.userManager.getOrFetch(player);
        if (this.spyLogger != null && user.getProperty(ChatProperties.getSpyLogProperty(spyType)).booleanValue()) {
            this.spyLogger.addEntry(formatted);
        }
    }

    public void handleChatMessage(@NotNull UniversalChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String originalMessage = event.message();
        UserChatCache data = this.getChatCache(player);
        String format = this.getEffectiveChatFormat(player);
        ChatChannel channel = this.getEffectiveChannel(player, Character.valueOf(originalMessage.charAt(0)));
        MessageContext context = new MessageContext(player, data, originalMessage, format, channel, event.viewers());
        ArrayList processors = new ArrayList();
        processors.add(new ColorProcessor());
        processors.add(new ChannelProcessor((SunLightPlugin)this.plugin));
        if (this.settings.isAntiFloodEnabled() && !player.hasPermission(ChatPerms.BYPASS_ANTI_FLOOD)) {
            processors.add(new AntiFloodProcessor());
        }
        if (this.settings.isAntiCapsEnabled() && !player.hasPermission(ChatPerms.BYPASS_ANTI_CAPS)) {
            processors.add(new AntiCapsProcessor());
        }
        if (this.settings.getProfanityFilterEnabled() && !player.hasPermission(ChatPerms.BYPASS_PROFANITY_FILTER) && this.wordFilter != null) {
            processors.add(new FilterProcessor(this.wordFilter));
        }
        processors.add(new FormatProcessor());
        if (this.settings.isItemShowEnabled()) {
            processors.add(new ItemDisplayProcessor());
        }
        if (this.settings.isMentionsEnabled()) {
            processors.add(new MentionProcessor(this.mentionsPattern, this.userManager));
        }
        if (this.settings.isSpyEnabled() && !player.hasPermission(ChatPerms.BYPASS_SPY)) {
            processors.add(new SpyProcessor());
        }
        if (this.discordHandler != null) {
            processors.add(new DiscordProcessor(this.discordHandler));
        }
        if (!this.process(processors, context)) {
            event.setCancelled(true);
            return;
        }
        event.editViewers(viewers -> {
            viewers.clear();
            viewers.addAll(context.getViewers());
        });
        event.message(NightMessage.parse((String)context.getMessage()));
        event.renderer((source, sourceDisplayName, message, viewer) -> NightMessage.parse((String)context.getFormat()));
    }

    public void handleCommandEvent(@NotNull PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UserChatCache cache = this.getChatCache(player);
        String originalMessage = event.getMessage();
        CommandContext context = new CommandContext(player, cache, originalMessage);
        ArrayList processors = new ArrayList();
        String commandName = context.getCommandName();
        if (this.settings.isAntiFloodEnabled() && !this.settings.isAntiFloodWhitelistedCommand(commandName) && !player.hasPermission(ChatPerms.BYPASS_ANTI_FLOOD)) {
            processors.add(new CommandCooldownProcessor());
            processors.add(new AntiFloodProcessor());
        }
        if (this.settings.isAntiCapsEnabled() && this.settings.isAntiCapsBlacklistedCommand(commandName) && !player.hasPermission(ChatPerms.BYPASS_ANTI_CAPS)) {
            processors.add(new AntiCapsProcessor());
        }
        if (this.settings.getProfanityFilterEnabled() && this.settings.isProfanityFilterAffectedCommand(commandName) && !player.hasPermission(ChatPerms.BYPASS_PROFANITY_FILTER) && this.wordFilter != null) {
            processors.add(new FilterProcessor(this.wordFilter));
        }
        if (this.settings.isSpyEnabled() && !player.hasPermission(ChatPerms.BYPASS_SPY)) {
            processors.add(new SpyProcessor());
        }
        if (!this.process(processors, context)) {
            event.setCancelled(true);
            return;
        }
        event.setMessage(context.getMessage());
    }

    public boolean sendPrivateMessage(@NotNull Player player, @NotNull Player target, @NotNull String message) {
        if (player == target) {
            this.sendPrefixed(ChatLang.CONVERSATIONS_SEND_YOURSELF, (CommandSender)player);
            return false;
        }
        SunUser targetUser = (SunUser)this.userManager.getOrFetch(target);
        if (!targetUser.getProperty(ChatProperties.CONVERSATIONS).booleanValue() && !player.hasPermission(ChatPerms.BYPASS_CONVERSATIONS_DISABLED)) {
            this.sendPrefixed(ChatLang.CONVERSATIONS_SEND_DENIED, (CommandSender)player, (PlaceholderContext.Builder replacer) -> replacer.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
            return false;
        }
        PlayerPrivateMessageEvent event = new PlayerPrivateMessageEvent(player, target, message);
        ((SunLightPlugin)this.plugin).getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.handlePrivateMessage(event);
        return true;
    }

    public void handlePrivateMessage(@NotNull PlayerPrivateMessageEvent event) {
        Player player = event.getSender();
        Player target = event.getTarget();
        String originalMessage = event.getMessage();
        String proxyFormat = this.settings.getConversationProxyFormat();
        UserChatCache cache = this.getChatCache(player);
        ConversationContext context = new ConversationContext(player, cache, originalMessage, proxyFormat, target);
        ArrayList processors = new ArrayList();
        processors.add(new ColorProcessor());
        if (this.settings.isAntiFloodEnabled() && !player.hasPermission(ChatPerms.BYPASS_ANTI_FLOOD)) {
            processors.add(new AntiFloodProcessor());
        }
        if (this.settings.isAntiCapsEnabled() && !player.hasPermission(ChatPerms.BYPASS_ANTI_CAPS)) {
            processors.add(new AntiCapsProcessor());
        }
        if (this.settings.getProfanityFilterEnabled() && !player.hasPermission(ChatPerms.BYPASS_PROFANITY_FILTER) && this.wordFilter != null) {
            processors.add(new FilterProcessor(this.wordFilter));
        }
        if (this.settings.isItemShowEnabled()) {
            processors.add(new ItemDisplayProcessor());
        }
        if (this.settings.isSpyEnabled() && !player.hasPermission(ChatPerms.BYPASS_SPY)) {
            processors.add(new SpyProcessor());
        }
        processors.add(new ConversationProcessor());
        this.process(processors, context);
    }

    private <T extends ChatContext> boolean process(@NotNull List<ChatProcessor<? super T>> processors, @NotNull T context) {
        for (ChatProcessor<ChatProcessor> chatProcessor : processors) {
            chatProcessor.preProcess(this, (ChatProcessor)((Object)context));
            if (!context.isCancelled()) continue;
            return false;
        }
        processors.forEach(messageProcessor -> messageProcessor.postProcess(this, context));
        return true;
    }
}

