/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Numbers;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentReason;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;
import su.nightexpress.sunlight.module.bans.time.BanTime;
import su.nightexpress.sunlight.module.bans.time.BanTimeUnit;

public class BansSettings
extends AbstractConfig {
    private static final ConfigType<BanTime> DURATION_LIMIT_CONFIG_TYPE = ConfigType.of((config, path) -> Optional.ofNullable(config.getString(path)).map(BanTime::parse).orElse(null), (config, path, value) -> config.set(path, (Object)value.serialize()));
    private static final ConfigType<PunishmentReason> PUNISHMENT_REASON_CONFIG_TYPE = ConfigType.of(PunishmentReason::read, FileConfig::set);
    public ConfigProperty<String> dataTablePrefix = this.addProperty(ConfigTypes.STRING, "Data.Table-Prefix", "sunlight_bans", new String[]{"Sets the prefix for the database table.", "[Case #1] Use different prefixes on different servers to isolate data from one another.", "[Case #2] Use the same prefix across multiple servers to synchronize data between them."});
    public ConfigProperty<Integer> dataSaveInterval = this.addProperty(ConfigTypes.INT, "Data.Save-Interval", 10, new String[]{"Sets how often (in seconds) changes to punishment data will be written to the database.", "This applies, for example, when the punishment status is changed through the GUI."});
    public final ConfigProperty<Integer> consolePriority = this.addProperty(ConfigTypes.INT, "Priority.Console", 10000, new String[]{"Sets the priority for punishment operations executed through the console.", "This allows console to kick, ban, mute and warn players whose rank priority is under the console's one."});
    public final ConfigProperty<Map<String, Integer>> rankPriorities = this.addProperty(ConfigTypes.forMapWithLowerKeys((ConfigType)ConfigTypes.INT), "Priority.Ranks", Map.of("moderator", 50, "admin", 100, "owner", 999), new String[]{"Sets the priority for punishment operations executed by players based on their rank (aka permission group).", "This allows players to kick, ban, mute and warn other players with smaller rank priority.", "The greatest value is always used.", "[*] Requires LuckPerms for the best experience. If LuckPerms is not installed, this feature will not work properly for offline players."});
    public final ConfigProperty<Map<BanTimeUnit, String[]>> timeUnitAliases = this.addProperty(ConfigTypes.forMap(string -> (BanTimeUnit)Enums.get((String)string, BanTimeUnit.class), unit -> LowerCase.INTERNAL.apply(unit.name()), (ConfigType)ConfigTypes.STRING_ARRAY), "Time.Unit-Aliases", BansSettings.getDefaultAliases(), new String[]{"Here you can specify custom aliases (right side only) for time units used in punishment commands. Split with comma."});
    public final ConfigProperty<Map<String, Map<PunishmentType, BanTime>>> durationLimitsRanks = this.addProperty(ConfigTypes.forMap(arg_0 -> ((LowerCase)LowerCase.INTERNAL).apply(arg_0), s -> s, (ConfigType)ConfigTypes.forMap(string -> (PunishmentType)Enums.get((String)string, PunishmentType.class), Enum::name, DURATION_LIMIT_CONFIG_TYPE)), "Time.Duration-Limits.Ranks", BansSettings.getDefaultDurationLimits(), new String[]{"Here you can set the maximum allowed time limit for each type of punishment, based on the rank of the player issuing the punishment.", "If a player belongs to multiple ranks, the highest available limit will be selected for them.", "- Limit Format: [AMOUNT] [TIME UNIT], for example: 4 %s".formatted(BanTimeUnit.DAYS.name()), "- Available Time Units: [%s]".formatted(Enums.inline(BanTimeUnit.class)), "- Available Punishment Types: [%s]".formatted(Enums.inline(PunishmentType.class)), "[*] To remove the limit for a specific punishment type, use -1 without a time unit.", "[*] To remove all limits for a specific group, completely delete that group's section from the file", "[*] To bypass all limits, give '%s' permission.".formatted(BansPerms.BYPASS_DURATION_LIMIT.getName()), "[*] Requires Vault with a compatible permissions plugin OR LuckPerms to work."});
    public final ConfigProperty<Boolean> durationLimitsForPardon = this.addProperty(ConfigTypes.BOOLEAN, "Time.Duration-Limits.Include-For-Pardon", true, new String[]{"Controls whether duration limit settings above should apply to pardon commands (/unban, /unmute, /unwarn).", "This will prevent players to /unban, /unmute or /unwarn other players if other player's remaining punishment time is greater than the one available by the limit settings."});
    public final ConfigProperty<Set<String>> immunityList = this.addProperty(ConfigTypes.STRING_SET_LOWER_CASE, "Security.Immunity-List", Set.of("add_your_names_or_uuids_or_ips", "127.0.0.1", "0.0.0.0"), new String[]{"List of player names/IPs/UUIDs that are immune to all punishments no matter what."});
    public final ConfigProperty<Map<String, PunishmentReason>> reasonMap = this.addProperty(ConfigTypes.forMapWithLowerKeys(PUNISHMENT_REASON_CONFIG_TYPE), "General.Reasons", BansSettings.getDefaultReasons(), new String[]{"Define here punishment reasons to use in the punishment commands."});
    public final ConfigProperty<List<String>> disconnectScreenKick = this.addProperty(ConfigTypes.STRING_LIST, "Disconnect-Screen.Kick", List.of(TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap("YOU HAVE BEEN KICKED"), "", TagWrappers.WHITE.wrap("\"%punishment_reason%\"")), new String[]{"Text to display in disconnect window for kicked players."});
    public final ConfigProperty<List<String>> disconnectScreenPermaBan = this.addProperty(ConfigTypes.STRING_LIST, "Disconnect-Screen.Permanent-Ban", Lists.newList((Object[])new String[]{(String)TagWrappers.SPRITE.apply("items", "item/barrier") + TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap(" YOU ARE PERMANENTLY BANNED ") + (String)TagWrappers.SPRITE.apply("items", "item/barrier"), "", TagWrappers.WHITE.wrap("You " + TagWrappers.GRAY.wrap("(" + TagWrappers.YELLOW.wrap("%punishment_user%") + ")") + " have been permanently banned " + TagWrappers.YELLOW.wrap("%punishment_date_created%") + " with the following reason: " + TagWrappers.SOFT_RED.wrap("\"%punishment_reason%\"") + "."), "", TagWrappers.WHITE.wrap("If you believe this happened by mistake, you can appeal the ban here: " + TagWrappers.GREEN.wrap("< INSERT YOUR URL >"))}), new String[]{"Text to display in disconnect window for permanently banned players."});
    public final ConfigProperty<List<String>> disconnectScreenTempBan = this.addProperty(ConfigTypes.STRING_LIST, "Disconnect-Screen.Temp-Ban", Lists.newList((Object[])new String[]{(String)TagWrappers.SPRITE.apply("items", "item/barrier") + TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap(" YOU ARE TEMPORARY BANNED ") + (String)TagWrappers.SPRITE.apply("items", "item/barrier"), "", TagWrappers.WHITE.wrap("You " + TagWrappers.GRAY.wrap("(" + TagWrappers.YELLOW.wrap("%punishment_user%") + ")") + " have been temporary banned " + TagWrappers.YELLOW.wrap("%punishment_date_created%") + " with the following reason: " + TagWrappers.SOFT_RED.wrap("\"%punishment_reason%\"") + "."), "", TagWrappers.WHITE.wrap("You will be unbanned " + TagWrappers.GOLD.wrap("%punishment_date_expired%") + TagWrappers.GRAY.wrap(" (in %punishment_expires_in%)")), "", TagWrappers.WHITE.wrap("If you believe this happened by mistake, you can appeal the ban here: " + TagWrappers.GREEN.wrap("< INSERT YOUR URL >"))}), new String[]{"Text to display in disconnect window for temporary banned players."});
    public final ConfigProperty<List<String>> disconnectScreenIpBan = this.addProperty(ConfigTypes.STRING_LIST, "Disconnect-Screen.IP-Ban", List.of((String)TagWrappers.SPRITE.apply("items", "item/barrier") + TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap(" YOUR IP ADDRESS IS BANNED ") + (String)TagWrappers.SPRITE.apply("items", "item/barrier"), "", TagWrappers.WHITE.wrap("Your IP address " + TagWrappers.GRAY.wrap("(" + TagWrappers.YELLOW.wrap("%punishment_user%") + ")") + " has been banned " + TagWrappers.YELLOW.wrap("%punishment_date_created%") + " with the following reason: " + TagWrappers.SOFT_RED.wrap("\"%punishment_reason%\"") + "."), "", TagWrappers.WHITE.wrap("If you believe this happened by mistake, you can appeal the ban here: " + TagWrappers.GREEN.wrap("< INSERT YOUR URL >"))), new String[]{"Text to display in disconnect window for players with banned IPs."});
    public final ConfigProperty<Boolean> altDetectorEnabled = this.addProperty(ConfigTypes.BOOLEAN, "AltDetector.Enabled", true, new String[]{"Controls whether Alt Detector feature is enabled."});
    public final ConfigProperty<Boolean> muteBlockCommandsEnabled = this.addProperty(ConfigTypes.BOOLEAN, "Mute.Block-Commands.Enabled", true, new String[]{"Controls whether muted players will be restricted from using certain commands."});
    public final ConfigProperty<Set<String>> muteBlockCommandsList = this.addProperty(ConfigTypes.STRING_SET, "Mute.Block-Commands.List", Set.of("me", "broadcast"), new String[]{"Commands to block for muted players (without the '/' slash)."});
    public final ConfigProperty<Integer> warnMaxAmountToReset = this.addProperty(ConfigTypes.INT, "Warn.Max-Amount-To-Reset", 5, new String[]{"Sets the warn limit for a player.", "When this limit is reached, all active warnings are automatically reset.", "This setting is required for the 'Commands-For-Active-Warns' setting to function correctly.", "[*] Set to '-1' to disable."});
    public final ConfigProperty<Map<Integer, List<String>>> warnAutoCommands = this.addProperty(ConfigTypes.forMap(key -> Numbers.parseInteger((String)key).orElse(null), String::valueOf, (ConfigType)ConfigTypes.STRING_LIST), "Warn.Commands-For-Active-Warns", Map.of(3, Lists.newList((Object[])new String[]{"smite %player_name%"}), 5, Lists.newList((Object[])new String[]{"kick %player_name%"})), new String[]{"Runs the listed commands from the console when a player reaches a certain number of warns.", "[*] Placeholders: '%s', '%s'".formatted("%player_name%", "Punishment (https://nightexpressdev.com/)")});

    public boolean isAltCheckerEnabled() {
        return (Boolean)this.altDetectorEnabled.get();
    }

    @NotNull
    private static Map<BanTimeUnit, String[]> getDefaultAliases() {
        LinkedHashMap<BanTimeUnit, String[]> aliases = new LinkedHashMap<BanTimeUnit, String[]>();
        for (BanTimeUnit unit : BanTimeUnit.values()) {
            String[] stringArray;
            switch (unit) {
                default: {
                    throw new MatchException(null, null);
                }
                case SECONDS: {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "sec";
                    stringArray = stringArray2;
                    stringArray2[1] = "s";
                    break;
                }
                case MINUTES: {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "min";
                    break;
                }
                case HOURS: {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "hour";
                    stringArray = stringArray4;
                    stringArray4[1] = "h";
                    break;
                }
                case DAYS: {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = "day";
                    stringArray = stringArray5;
                    stringArray5[1] = "d";
                    break;
                }
                case WEEKS: {
                    String[] stringArray6 = new String[2];
                    stringArray6[0] = "week";
                    stringArray = stringArray6;
                    stringArray6[1] = "w";
                    break;
                }
                case MONTHS: {
                    String[] stringArray7 = new String[1];
                    stringArray = stringArray7;
                    stringArray7[0] = "mon";
                    break;
                }
                case YEARS: {
                    String[] stringArray8 = new String[2];
                    stringArray8[0] = "year";
                    stringArray = stringArray8;
                    stringArray8[1] = "y";
                }
            }
            String[] names = stringArray;
            aliases.put(unit, names);
        }
        return aliases;
    }

    @NotNull
    private static Map<String, Map<PunishmentType, BanTime>> getDefaultDurationLimits() {
        LinkedHashMap<String, Map<PunishmentType, BanTime>> map = new LinkedHashMap<String, Map<PunishmentType, BanTime>>();
        Map durationMap1 = map.computeIfAbsent("moderator", k -> new LinkedHashMap());
        durationMap1.put(PunishmentType.MUTE, BanTime.temporary(BanTimeUnit.WEEKS, 1L));
        durationMap1.put(PunishmentType.BAN, BanTime.temporary(BanTimeUnit.MONTHS, 2L));
        durationMap1.put(PunishmentType.WARN, BanTime.temporary(BanTimeUnit.MONTHS, 3L));
        Map durationMap2 = map.computeIfAbsent("helper", k -> new LinkedHashMap());
        durationMap2.put(PunishmentType.MUTE, BanTime.temporary(BanTimeUnit.DAYS, 1L));
        durationMap2.put(PunishmentType.BAN, BanTime.temporary(BanTimeUnit.WEEKS, 2L));
        durationMap2.put(PunishmentType.WARN, BanTime.temporary(BanTimeUnit.WEEKS, 3L));
        return map;
    }

    @NotNull
    private static Map<String, PunishmentReason> getDefaultReasons() {
        HashMap<String, PunishmentReason> map = new HashMap<String, PunishmentReason>();
        map.put("default", new PunishmentReason("Violation of the rules"));
        map.put("advertisement", new PunishmentReason("Advertising other servers/websites"));
        map.put("grief", new PunishmentReason("Griefing"));
        map.put("toxic", new PunishmentReason("Toxic behavior"));
        map.put("cheating", new PunishmentReason("Cheating"));
        return map;
    }
}

