/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.command;

import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.argument.ArgumentType;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandArguments;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.bans.BansModule;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentContext;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentReason;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;
import su.nightexpress.sunlight.module.bans.time.BanTime;
import su.nightexpress.sunlight.module.bans.time.BanTimeUnit;
import su.nightexpress.sunlight.user.UserManager;

public class PunishmentCommandsProvider
extends AbstractCommandProvider {
    private static final String ARG_REASON = "reason";
    private final BansModule module;
    private final UserManager userManager;
    private final ArgumentType<BanTimeUnit> timeUnitArgumentType;
    private final ArgumentType<PunishmentReason> punishmentReasonArgumentType;

    public PunishmentCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull BansModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
        this.timeUnitArgumentType = (builder, string) -> Optional.ofNullable(module.getTimeUnitByAlias(string)).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)BansLang.COMMAND_SYNTAX_INVALID_TIME_UNIT));
        this.punishmentReasonArgumentType = (builder, string) -> Optional.ofNullable(this.module.getReasonById(string)).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)BansLang.COMMAND_SYNTAX_INVALID_REASON));
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("ban", true, new String[]{"ban"}, builder -> this.buildPunishment((LiteralNodeBuilder)builder, PunishmentType.BAN, true));
        this.registerLiteral("mute", true, new String[]{"mute"}, builder -> this.buildPunishment((LiteralNodeBuilder)builder, PunishmentType.MUTE, true));
        this.registerLiteral("warn", true, new String[]{"warn"}, builder -> this.buildPunishment((LiteralNodeBuilder)builder, PunishmentType.WARN, true));
        this.registerLiteral("tempban", true, new String[]{"tempban"}, builder -> this.buildPunishment((LiteralNodeBuilder)builder, PunishmentType.BAN, false));
        this.registerLiteral("tempmute", true, new String[]{"tempmute"}, builder -> this.buildPunishment((LiteralNodeBuilder)builder, PunishmentType.MUTE, false));
        this.registerLiteral("tempwarn", true, new String[]{"tempwarn"}, builder -> this.buildPunishment((LiteralNodeBuilder)builder, PunishmentType.WARN, false));
        this.registerLiteral("banip", true, new String[]{"banip", "ipban"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(BansLang.COMMAND_BAN_IP_DESC)).permission(BansPerms.COMMAND_BAN_IP)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.inetAddress("address"), this.reasonArgument().optional()}).withFlags(new String[]{"s"}).executes(this::banInet));
        this.registerLiteral("kick", true, new String[]{"kick"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(BansLang.COMMAND_KICK_DESC)).permission(BansPerms.COMMAND_KICK)).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player"), this.reasonArgument().optional()}).withFlags(new String[]{"s"}).executes(this::kick));
    }

    @NotNull
    private ArgumentNodeBuilder<PunishmentReason> reasonArgument() {
        return Commands.argument((String)ARG_REASON, this.punishmentReasonArgumentType).localized(BansLang.COMMAND_ARGUMENT_NAME_REASON).suggestions((reader, tabContext) -> this.module.getReasonIds());
    }

    private void buildPunishment(@NotNull LiteralNodeBuilder builder, @NotNull PunishmentType type, boolean isPermament) {
        TextLocale description = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansLang.COMMAND_BAN_DESC;
            case PunishmentType.MUTE -> BansLang.COMMAND_MUTE_DESC;
            case PunishmentType.WARN -> BansLang.COMMAND_WARN_DESC;
        };
        Permission permission = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansPerms.COMMAND_BAN;
            case PunishmentType.MUTE -> BansPerms.COMMAND_MUTE;
            case PunishmentType.WARN -> BansPerms.COMMAND_WARN;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(permission)).withFlags(new String[]{"s"}).executes((context, arguments) -> this.punishPlayer(context, arguments, type));
        if (isPermament) {
            builder.withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), this.reasonArgument().optional()});
        } else {
            builder.withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player"), Arguments.integer((String)"amount", (int)1).localized(Lang.COMMAND_ARGUMENT_NAME_TIME).suggestions((reader, context) -> List.of("1", "10", "30", "60")), Commands.argument((String)"type", this.timeUnitArgumentType).localized(BansLang.COMMAND_ARGUMENT_NAME_TIME_UNIT).suggestions((reader, context) -> this.module.getTimeUnitAliases()), this.reasonArgument().optional()});
        }
    }

    private boolean punishPlayer(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull PunishmentType type) {
        CommandSender sender = context.getSender();
        String playerName = arguments.getString("player");
        this.userManager.loadTargetProfile(playerName).thenCompose(profile -> {
            if (profile == null) {
                context.errorBadPlayer();
                return CompletableFuture.completedFuture(null);
            }
            int duration = arguments.getInt("amount");
            BanTimeUnit timeUnit = (BanTimeUnit)arguments.get("type", BanTimeUnit.class);
            PunishmentReason reason = (PunishmentReason)arguments.getOr(ARG_REASON, PunishmentReason.class, (Object)this.module.getDefaultReason());
            boolean silent = context.hasFlag("s");
            BanTime banTime = BanTime.temporary(timeUnit, duration);
            PunishmentContext punishmentContext = new PunishmentContext(type, reason, banTime, silent);
            return this.module.punishPlayer(sender, (UserInfo)profile, punishmentContext);
        });
        return true;
    }

    private boolean banInet(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        InetAddress address = (InetAddress)arguments.get("address", InetAddress.class);
        PunishmentReason reason = (PunishmentReason)arguments.getOr(ARG_REASON, PunishmentReason.class, (Object)this.module.getDefaultReason());
        boolean silent = context.hasFlag("s");
        BanTime banTime = BanTime.permanent();
        return this.module.banInet(context.getSender(), address, reason, banTime, silent);
    }

    private boolean kick(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = arguments.getPlayer("player");
        PunishmentReason reason = (PunishmentReason)arguments.getOr(ARG_REASON, PunishmentReason.class, (Object)this.module.getDefaultReason());
        boolean silent = context.hasFlag("s");
        return this.module.kick(context.getSender(), player, reason, silent);
    }
}

