/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.command;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.bans.BansModule;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.user.UserManager;

public class AltsCommandProvider
extends AbstractCommandProvider {
    private final BansModule module;
    private final UserManager userManager;

    public AltsCommandProvider(@NotNull SunLightPlugin plugin, @NotNull BansModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("alts", true, new String[]{"alts"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(BansLang.COMMAND_ALTS_DESC)).permission(BansPerms.COMMAND_ALTS)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player")}).executes(this::showAlts));
    }

    private boolean showAlts(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String playerName = arguments.getString("player");
        this.userManager.loadTargetProfile(playerName).thenCompose(profile -> {
            if (profile == null) {
                context.errorBadPlayer();
                return CompletableFuture.completedFuture(null);
            }
            return this.userManager.loadInetAddress(profile.id()).thenCompose(address -> {
                if (address == null) {
                    context.errorBadPlayer();
                    return CompletableFuture.completedFuture(null);
                }
                return this.module.lookupAltProfiles((InetAddress)address).thenAcceptAsync(alts -> this.module.notifyAltProfiles(context.getSender(), (UserInfo)profile, (InetAddress)address, (List<UserInfo>)alts), arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0));
            });
        });
        return true;
    }
}

