/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.backlocation.data;

import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoredLocation {
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;
    private final long expireDate;

    public StoredLocation(@NotNull String worldName, double x, double y, double z, int duration) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.expireDate = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(duration, TimeUnit.SECONDS);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expireDate;
    }

    public boolean isValid() {
        return this.getWorld() != null;
    }

    @Nullable
    public World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    @Nullable
    public Location toLocation() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return new Location(world, this.x, this.y, this.z);
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getExpireDate() {
        return this.expireDate;
    }
}

