/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.afk;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEvent;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEventHandler;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.RankTable;
import su.nightexpress.nightcore.util.geodata.pos.BlockPos;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.afk.ActivityTracker;
import su.nightexpress.sunlight.module.afk.ActivityType;
import su.nightexpress.sunlight.module.afk.command.AfkCommandProvider;
import su.nightexpress.sunlight.module.afk.config.AfkLang;
import su.nightexpress.sunlight.module.afk.config.AfkPerms;
import su.nightexpress.sunlight.module.afk.config.AfkSettings;
import su.nightexpress.sunlight.module.afk.event.PlayerAfkEvent;
import su.nightexpress.sunlight.module.afk.listener.AfkListener;

public class AfkModule
extends Module {
    private final Map<UUID, ActivityTracker> activityTrackerMap = new ConcurrentHashMap<UUID, ActivityTracker>();
    private final AfkSettings settings = new AfkSettings();
    private UniversalChatEventHandler chatEventHandler;

    public AfkModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        ((SunLightPlugin)this.plugin).injectLang(AfkLang.class);
        this.registerCommands();
        this.addListener((SimpeListener)new AfkListener((SunLightPlugin)this.plugin, this));
        if (this.settings.getActivityPoints(ActivityType.CHAT) > 0) {
            this.chatEventHandler = this::handleChatEvent;
            ((SunLightPlugin)this.plugin).addChatHandler(EventPriority.MONITOR, this.chatEventHandler);
        }
        this.addTask(this::tickTrackers, 1);
        ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers().forEach(this::track);
    }

    @Override
    protected void unloadModule() {
        if (this.chatEventHandler != null) {
            ((SunLightPlugin)this.plugin).removeChatHandler(this.chatEventHandler);
            this.chatEventHandler = null;
        }
        Players.getOnline().forEach(player -> this.exitAfk((Player)player, true));
        this.activityTrackerMap.clear();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(AfkPerms.MODULE_ROOT);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("afk", new AfkCommandProvider((SunLightPlugin)this.plugin, this));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
        registry.register("afk_state", (player, payload) -> CoreLang.STATE_YES_NO.get(this.isAfk(player)));
        registry.register("afk_mode", (player, payload) -> PlaceholderContext.builder().with("%time%", () -> TimeFormats.formatSince((long)this.getAfkEnterTimestamp(player), (TimeFormatType)TimeFormatType.LITERAL)).build().apply(AfkLang.PLACEHOLDER_MODE.get(this.isAfk(player))));
        registry.register("afk_idle_time", (player, payload) -> String.valueOf(this.getIdleTime(player)));
        registry.register("afk_idle_time_formatted", (player, payload) -> TimeFormats.formatAmount((long)TimeUnit.MILLISECONDS.convert(this.getIdleTime(player), TimeUnit.SECONDS), (TimeFormatType)TimeFormatType.LITERAL));
    }

    public void kickForIdling(@NotNull Player player) {
        String reason = PlaceholderContext.builder().with("%time%", () -> TimeFormats.formatAmount((long)TimeUnit.MILLISECONDS.convert(this.getIdleTime(player), TimeUnit.SECONDS), (TimeFormatType)TimeFormatType.LITERAL)).andThen(SLPlaceholders.forPlayerWithPAPI((Player)player)).build().apply(String.join((CharSequence)"\n", (Iterable)this.settings.kickText.get()));
        Players.kick((Player)player, (String)reason);
    }

    public boolean isAfk(@NotNull Player player) {
        return this.activityTracker(player).map(ActivityTracker::isAfk).orElse(false);
    }

    public void track(@NotNull Player player) {
        ActivityTracker tracker = new ActivityTracker(this.settings);
        this.activityTrackerMap.put(player.getUniqueId(), tracker);
    }

    public void untrack(@NotNull Player player, boolean silent) {
        this.exitAfk(player, silent);
        this.activityTrackerMap.remove(player.getUniqueId());
    }

    public void exitAfk(@NotNull Player player, boolean silent) {
        this.activityTracker(player).filter(ActivityTracker::isAfk).ifPresent(tracker -> {
            this.handleAfkExit(player, (ActivityTracker)tracker, silent);
            tracker.resetCounters();
        });
    }

    public void enterAfk(@NotNull Player player, boolean silent) {
        this.activityTracker(player).filter(Predicate.not(ActivityTracker::isAfk)).ifPresent(tracker -> this.handleAfkEnter(player, (ActivityTracker)tracker, silent));
    }

    public void trackActivity(@NotNull Player player, @NotNull ActivityType type) {
        this.activityTracker(player).ifPresent(tracker -> tracker.countActivity(type));
    }

    public void trackActivity(@NotNull Player player, int amount) {
        this.activityTracker(player).ifPresent(tracker -> tracker.countActivity(amount));
    }

    private void tickTrackers() {
        Map.copyOf(this.activityTrackerMap).forEach((playerId, tracker) -> {
            Player player = Players.getPlayer((UUID)playerId);
            if (player == null) {
                return;
            }
            tracker.updatePosition(BlockPos.from((Location)player.getLocation()));
            tracker.tick();
            if (tracker.isAfk()) {
                if (tracker.isEnoughActivity()) {
                    this.handleAfkExit(player, (ActivityTracker)tracker, false);
                    return;
                }
                if (((Boolean)this.settings.afkStatusBarEnabled.get()).booleanValue()) {
                    Players.sendActionBar((Player)player, (String)PlaceholderContext.builder().with("%time%", () -> TimeFormats.formatSince((long)tracker.getAfkEnterTimestamp(), (TimeFormatType)TimeFormatType.LITERAL)).andThen(SLPlaceholders.forPlayerWithPAPI((Player)player)).build().apply((String)this.settings.afkStatusBarText.get()));
                }
            } else if (!tracker.isAfk()) {
                int idleTime = tracker.getIdleTime();
                int timeToAfk = this.getTimeToAfk(player);
                if (timeToAfk > 0 && idleTime >= timeToAfk) {
                    int timeToKick = this.getTimeToKick(player);
                    if (timeToKick > 0 && idleTime >= timeToKick) {
                        this.kickForIdling(player);
                        return;
                    }
                    this.handleAfkEnter(player, (ActivityTracker)tracker, false);
                }
            }
        });
    }

    private void handleChatEvent(@NotNull UniversalChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.trackActivity(event.getPlayer(), this.settings.getActivityPoints(ActivityType.CHAT));
    }

    private void handleAfkEnter(@NotNull Player player, @NotNull ActivityTracker tracker, boolean silent) {
        tracker.resetCounters();
        tracker.setAfkTimestamp();
        PlaceholderContext context = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)player)).andThen(CommonPlaceholders.forPlaceholderAPI((Player)player)).build();
        List commands = context.apply((List)this.settings.afkCommands.get());
        Players.dispatchCommands((Player)player, (List)commands);
        PlayerAfkEvent event = new PlayerAfkEvent(player, true);
        ((SunLightPlugin)this.plugin).getPluginManager().callEvent((Event)event);
        if (!silent) {
            this.broadcastPrefixed(AfkLang.AFK_ENTER_BROADCAST, context);
        }
    }

    private void handleAfkExit(@NotNull Player player, @NotNull ActivityTracker tracker, boolean silent) {
        PlaceholderContext context = PlaceholderContext.builder().with("%time%", () -> TimeFormats.formatSince((long)tracker.getAfkEnterTimestamp(), (TimeFormatType)TimeFormatType.LITERAL)).with(CommonPlaceholders.PLAYER.resolver((Object)player)).andThen(CommonPlaceholders.forPlaceholderAPI((Player)player)).build();
        List commands = context.apply((List)this.settings.wakeUpCommands.get());
        Players.dispatchCommands((Player)player, (List)commands);
        PlayerAfkEvent event = new PlayerAfkEvent(player, false);
        ((SunLightPlugin)this.plugin).getPluginManager().callEvent((Event)event);
        if (!silent) {
            this.broadcastPrefixed(AfkLang.AFK_EXIT_BROADCAST, context);
        }
        tracker.resetCounters();
    }

    @NotNull
    public Set<ActivityTracker> getActivityTrackers() {
        return new HashSet<ActivityTracker>(this.activityTrackerMap.values());
    }

    @Nullable
    public ActivityTracker getActivityTracker(@NotNull Player player) {
        return this.getActivityTracker(player.getUniqueId());
    }

    @Nullable
    public ActivityTracker getActivityTracker(@NotNull UUID playerId) {
        return this.activityTrackerMap.get(playerId);
    }

    @NotNull
    public Optional<ActivityTracker> activityTracker(@NotNull Player player) {
        return Optional.ofNullable(this.getActivityTracker(player));
    }

    public int getTimeToAfk(@NotNull Player player) {
        return ((RankTable)this.settings.idleAfkTimes.get()).getGreatest(player).intValue();
    }

    public int getTimeToKick(@NotNull Player player) {
        return ((RankTable)this.settings.idleKickTimes.get()).getGreatest(player).intValue();
    }

    public int getIdleTime(@NotNull Player player) {
        return this.activityTracker(player).map(ActivityTracker::getIdleTime).orElse(0);
    }

    public long getAfkEnterTimestamp(@NotNull Player player) {
        return this.activityTracker(player).map(ActivityTracker::getAfkEnterTimestamp).orElse(0L);
    }
}

