/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module;

import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.registry.NightRegistry;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.sunlight.module.Module;

public class ModuleRegistry {
    private final NightRegistry<String, Module> byId = new NightRegistry();
    private final NightRegistry<Class<?>, Module> byType = new NightRegistry();

    public void reload() {
        this.getModules().forEach(SimpleManager::setup);
    }

    public boolean register(@NotNull Module module) throws IllegalStateException {
        if (this.isPresent(module.getId())) {
            throw new IllegalStateException("Module with such ID is already registered!");
        }
        if (this.isPresent(((Object)((Object)module)).getClass())) {
            throw new IllegalStateException("Module of such type is already registered!");
        }
        this.byId.register((Object)module.getId(), (Object)module);
        this.byType.register(((Object)((Object)module)).getClass(), (Object)module);
        module.init();
        module.setup();
        return true;
    }

    public void clear() {
        this.getModules().forEach(AbstractManager::shutdown);
        this.byId.clear();
        this.byType.clear();
    }

    public boolean isPresent(@NotNull String id) {
        return this.byId(id).isPresent();
    }

    public <T extends Module> boolean isPresent(@NotNull Class<T> type) {
        return this.byType(type).isPresent();
    }

    @NotNull
    public Optional<Module> byId(@NotNull String id) {
        return this.byId.lookup((Object)id);
    }

    @NotNull
    public <T extends Module> Optional<T> byType(@NotNull Class<T> type) {
        return this.byType.lookup(type).map(type::cast);
    }

    @Nullable
    public Module getById(@NotNull String id) {
        return (Module)((Object)this.byId.byKey((Object)id));
    }

    @NotNull
    public Set<Module> getModules() {
        return this.byType.values();
    }
}

