/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.sunlight.SLUtils;

public class LoadCondition {
    private static final LoadCondition SUCCESS = new LoadCondition(true, null);
    private final boolean success;
    private final String reason;

    private LoadCondition(boolean success, @Nullable String reason) {
        this.success = success;
        this.reason = reason;
    }

    @NotNull
    public static LoadCondition success() {
        return SUCCESS;
    }

    @NotNull
    public static LoadCondition failure(@NotNull String reason) {
        return new LoadCondition(false, reason);
    }

    @NotNull
    public static LoadCondition packetLibrary() {
        return SLUtils.hasPacketLibrary() ? LoadCondition.success() : LoadCondition.failure("No packet library plugin installed. Install %s or %s for the module to work.".formatted("packetevents", "ProtocolLib"));
    }

    public boolean isSuccess() {
        return this.success;
    }

    @NotNull
    public Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }
}

