/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.dialog;

import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.registry.NightRegistry;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.dialog.DialogKey;

public class DialogRegistry {
    private final SunLightPlugin plugin;
    private final NightRegistry<DialogKey<?>, Dialog<?>> backendRegistry;

    public DialogRegistry(@NotNull SunLightPlugin plugin) {
        this.plugin = plugin;
        this.backendRegistry = new NightRegistry();
    }

    public void clear() {
        this.backendRegistry.clear();
    }

    public <T> void register(@NotNull DialogKey<T> key, @NotNull Supplier<Dialog<T>> supplier) {
        this.register(key, supplier.get());
    }

    public <T> void register(@NotNull DialogKey<T> key, @NotNull Dialog<T> dialog) {
        this.backendRegistry.register(key, dialog);
        this.plugin.injectLang(dialog);
    }

    public <T> boolean show(@NotNull Player player, @NotNull DialogKey<T> key, @NotNull T data, @Nullable Runnable callback) {
        Dialog dialog = (Dialog)this.backendRegistry.byKey(key);
        if (dialog == null) {
            this.plugin.warn("Dialog '%s' not found or disabled.".formatted(key.id()));
            return false;
        }
        dialog.show(player, data, callback);
        return true;
    }
}

