/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.data.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import su.nightexpress.nightcore.user.UserInfo;

public class UserInfoSerializer
implements JsonSerializer<UserInfo>,
JsonDeserializer<UserInfo> {
    public UserInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        UUID id = UUID.fromString(object.get("id").getAsString());
        String name = object.get("name").getAsString();
        return new UserInfo(id, name);
    }

    public JsonElement serialize(UserInfo userInfo, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("id", userInfo.id().toString());
        object.addProperty("name", userInfo.name());
        return object;
    }
}

