/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractDatabaseManager;
import su.nightexpress.nightcore.db.column.Column;
import su.nightexpress.nightcore.db.statement.condition.Operator;
import su.nightexpress.nightcore.db.statement.condition.Wheres;
import su.nightexpress.nightcore.db.statement.template.InsertStatement;
import su.nightexpress.nightcore.db.statement.template.SelectStatement;
import su.nightexpress.nightcore.db.statement.template.UpdateStatement;
import su.nightexpress.nightcore.db.table.Table;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.user.data.UserDataSchema;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandKey;
import su.nightexpress.sunlight.data.DataQueries;
import su.nightexpress.sunlight.data.UserColumns;
import su.nightexpress.sunlight.data.serialize.CommandKeySerializer;
import su.nightexpress.sunlight.data.serialize.UserInfoSerializer;
import su.nightexpress.sunlight.user.SunUser;

public class DataHandler
extends AbstractDatabaseManager<SunLightPlugin>
implements UserDataSchema<SunUser> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(UserInfo.class, (Object)new UserInfoSerializer()).registerTypeAdapter(CommandKey.class, (Object)new CommandKeySerializer()).create();
    private final Table usersTable = Table.builder((String)(this.getTablePrefix() + "_users")).withColumn(new Column[]{UserColumns.ID}).withColumn(new Column[]{UserColumns.UUID}).withColumn(new Column[]{UserColumns.NAME}).withColumn(new Column[]{UserColumns.DATE_CREATED}).withColumn(new Column[]{UserColumns.LAST_ONLINE}).withColumn(new Column[]{UserColumns.INET_ADDRESS}).withColumn(new Column[]{UserColumns.COMMAND_COOLDOWNS}).withColumn(new Column[]{UserColumns.PROPERTIES}).build();

    public DataHandler(@NotNull SunLightPlugin plugin) {
        super((NightPlugin)plugin);
    }

    public void onSynchronize() {
        this.synchronizer.syncAll();
    }

    protected void onInitialize() {
        this.createTable(this.usersTable);
        this.dropColumn(this.usersTable, new String[]{"ignoredUsers", "cooldowns", "settings"});
    }

    protected void onClose() {
    }

    public void onPurge() {
    }

    @NotNull
    public Table getUsersTable() {
        return this.usersTable;
    }

    @NotNull
    public Column<UUID> getUserIdColumn() {
        return UserColumns.UUID;
    }

    @NotNull
    public Column<String> getUserNameColumn() {
        return UserColumns.NAME;
    }

    @NotNull
    public SelectStatement<SunUser> getUserSelectStatement() {
        return DataQueries.SELECT_USER;
    }

    @NotNull
    public UpdateStatement<SunUser> getUserUpdateStatement() {
        return DataQueries.UPDATE_USER;
    }

    @NotNull
    public UpdateStatement<SunUser> getUserTinyUpdateStatement() {
        return DataQueries.UPDATE_USER_TINY;
    }

    @NotNull
    public InsertStatement<SunUser> getUserInsertStatement() {
        return DataQueries.INSERT_USER;
    }

    @NotNull
    public Optional<UserInfo> loadProfile(@NotNull String playerName) {
        return this.selectFirst(this.usersTable, DataQueries.SELECT_PROFILE, Wheres.where((String)UserColumns.NAME.getName(), (Operator)Operator.EQUALS_IGNORE_CASE, o -> playerName));
    }

    @NotNull
    public Optional<InetAddress> loadInetAddress(@NotNull UUID playerId) {
        return this.selectFirst(this.usersTable, DataQueries.SELECT_INET, Wheres.where((String)UserColumns.UUID.getName(), (Operator)Operator.EQUALS, o -> playerId));
    }

    @NotNull
    public List<UserInfo> getProfilesByInet(@NotNull InetAddress address) {
        String host = address.getHostAddress();
        return this.selectWhere(this.usersTable, DataQueries.SELECT_PROFILE, Wheres.where((String)UserColumns.INET_ADDRESS.getName(), (Operator)Operator.EQUALS, o -> host));
    }
}

