/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.command.provider.type;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.CommandProvider;
import su.nightexpress.sunlight.command.provider.definition.HubDefinition;
import su.nightexpress.sunlight.command.provider.definition.LiteralDefinition;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserManager;

public abstract class AbstractCommandProvider
implements CommandProvider {
    protected final SunLightPlugin plugin;
    protected final Map<String, Consumer<LiteralNodeBuilder>> literalBuilders;
    protected final Map<String, Consumer<HubNodeBuilder>> rootBuilder;
    protected final Map<String, LiteralDefinition> defaultLiterals;
    protected final Map<String, HubDefinition> defaultRoot;
    protected final Map<String, LiteralDefinition> literals;
    protected final Map<String, HubDefinition> root;

    public AbstractCommandProvider(@NotNull SunLightPlugin plugin) {
        this.plugin = plugin;
        this.literalBuilders = new HashMap<String, Consumer<LiteralNodeBuilder>>();
        this.rootBuilder = new HashMap<String, Consumer<HubNodeBuilder>>();
        this.defaultLiterals = new HashMap<String, LiteralDefinition>();
        this.defaultRoot = new HashMap<String, HubDefinition>();
        this.literals = new HashMap<String, LiteralDefinition>();
        this.root = new HashMap<String, HubDefinition>();
    }

    @Override
    public void load(@NotNull FileConfig config) {
        this.loadSettings(config, "Settings");
        this.loadLiterals(config, "LiteralNodes");
        this.loadRoot(config, "RootNodes");
    }

    @Deprecated
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    private void loadLiterals(@NotNull FileConfig config, @NotNull String path) {
        if (this.defaultLiterals.isEmpty()) {
            return;
        }
        this.defaultLiterals.forEach((id, definition) -> {
            String defPath = path + "." + id;
            if (!config.contains(defPath)) {
                config.set(defPath + ".Enabled", (Object)definition.enabled());
                config.setStringArray(defPath + ".Aliases", definition.aliases());
                config.set(defPath + ".Cooldown", (Object)definition.cooldown());
            }
        });
        config.getSection(path).forEach(sId -> {
            if (!this.literalBuilders.containsKey(sId)) {
                return;
            }
            String defPath = path + "." + sId;
            boolean enabled = config.getBoolean(defPath + ".Enabled");
            String[] aliases = config.getStringArray(defPath + ".Aliases");
            int cooldown = config.getInt(defPath + ".Cooldown");
            this.literals.put(LowerCase.INTERNAL.apply(sId), new LiteralDefinition(enabled, aliases, cooldown));
        });
    }

    private void loadRoot(@NotNull FileConfig config, @NotNull String path) {
        if (this.defaultRoot.isEmpty()) {
            return;
        }
        this.defaultRoot.forEach((id, definition) -> {
            String defPath = path + "." + id;
            if (!config.contains(defPath)) {
                config.set(defPath + ".Enabled", (Object)definition.enabled());
                config.setStringArray(defPath + ".Aliases", definition.aliases());
                config.set(defPath + ".Name", (Object)definition.name());
                definition.childrenAliases().forEach((childName, childAlias) -> config.set(defPath + ".Childrens." + childName, childAlias));
            }
        });
        config.getSection(path).forEach(sId -> {
            if (!this.rootBuilder.containsKey(sId)) {
                return;
            }
            String defPath = path + "." + sId;
            boolean enabled = config.getBoolean(defPath + ".Enabled");
            String[] aliases = config.getStringArray(defPath + ".Aliases");
            String name = config.getString(defPath + ".Name", "null");
            HashMap<String, String> childrenAliases = new HashMap<String, String>();
            config.getSection(defPath + ".Childrens").forEach(sId2 -> {
                String alias = config.getString(defPath + ".Childrens." + sId2);
                if (alias == null || alias.isBlank()) {
                    return;
                }
                if (!this.literalBuilders.containsKey(sId2)) {
                    return;
                }
                childrenAliases.put(LowerCase.INTERNAL.apply(sId2), alias);
            });
            this.root.put(LowerCase.INTERNAL.apply(sId), new HubDefinition(enabled, aliases, name, childrenAliases));
        });
    }

    protected void registerLiteral(@NotNull String id, boolean enabled, @NotNull String[] aliases, @NotNull Consumer<LiteralNodeBuilder> consumer) {
        this.defaultLiterals.put(LowerCase.INTERNAL.apply(id), new LiteralDefinition(enabled, aliases, 0));
        this.literalBuilders.put(LowerCase.INTERNAL.apply(id), consumer);
    }

    protected void registerRoot(@NotNull String name, boolean enabled, @NotNull String[] aliases, @NotNull Consumer<Map<String, String>> mapConsumer, @NotNull Consumer<HubNodeBuilder> consumer) {
        HashMap<String, String> childrenAliases = new HashMap<String, String>();
        mapConsumer.accept(childrenAliases);
        this.registerRoot(name, enabled, aliases, childrenAliases, consumer);
    }

    protected void registerRoot(@NotNull String name, boolean enabled, @NotNull String[] aliases, @NotNull Map<String, String> childrenAliases, @NotNull Consumer<HubNodeBuilder> consumer) {
        this.defaultRoot.put(LowerCase.INTERNAL.apply(name), new HubDefinition(enabled, aliases, StringUtil.capitalizeUnderscored((String)name), childrenAliases));
        this.rootBuilder.put(LowerCase.INTERNAL.apply(name), consumer);
    }

    @Override
    @NotNull
    public Map<String, HubDefinition> getRootDefinitions() {
        return this.root;
    }

    @Override
    @NotNull
    public Map<String, Consumer<HubNodeBuilder>> getRootBuilders() {
        return this.rootBuilder;
    }

    @Override
    @NotNull
    public Map<String, LiteralDefinition> getLiteralDefinitions() {
        return this.literals;
    }

    @Override
    @NotNull
    public Map<String, Consumer<LiteralNodeBuilder>> getLiteralBuilders() {
        return this.literalBuilders;
    }

    @Deprecated
    @Nullable
    protected Player getTargetOrSender(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull String argName, boolean loadData) {
        UserInfo profile;
        if (!arguments.contains(argName)) {
            if (!context.isPlayer()) {
                context.printUsage();
                return null;
            }
            return context.getPlayerOrThrow();
        }
        String playerName = arguments.getString(argName);
        Player target = Players.getPlayer((String)playerName);
        if (target != null) {
            Player sender;
            CommandSender commandSender = context.getSender();
            if (commandSender instanceof Player && !(sender = (Player)commandSender).canSee(target)) {
                context.errorBadPlayer();
                return null;
            }
            return target;
        }
        if (loadData && (profile = (UserInfo)this.plugin.getData().loadProfile(playerName).orElse(null)) != null) {
            target = this.plugin.getSunNMS().loadPlayerData(profile.id(), profile.name());
        }
        if (target == null) {
            context.errorBadPlayer();
            return null;
        }
        return target;
    }

    @Nullable
    protected World getWorld(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull String argName) {
        if (arguments.contains(argName)) {
            return arguments.getWorld(argName);
        }
        if (!context.isPlayer()) {
            context.printUsage();
            return null;
        }
        return context.getPlayerOrThrow().getWorld();
    }

    protected boolean forOnlinePlayerOrSender(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull Function<Player, Boolean> consumer) {
        Player sender;
        Player target;
        if (arguments.contains("player")) {
            target = arguments.getPlayer("player");
        } else {
            if (!context.isPlayer()) {
                context.printUsage();
                return false;
            }
            target = context.getPlayerOrThrow();
        }
        CommandSender commandSender = context.getSender();
        if (commandSender instanceof Player && !(sender = (Player)commandSender).canSee(target)) {
            context.errorBadPlayer();
            return false;
        }
        return consumer.apply(target);
    }

    protected void loadUserWithPlayerDataAsync(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull UserManager userManager, @NotNull BiConsumer<SunUser, Player> consumer) {
        String playerName = arguments.getString("player", context.getSender().getName());
        userManager.loadByNameAsync(playerName).thenCompose(userOptional -> {
            SunUser user = userOptional.orElse(null);
            if (user == null) {
                context.errorBadPlayer();
                return CompletableFuture.completedFuture(null);
            }
            return userManager.loadTargetPlayer(user).thenAcceptAsync(target -> consumer.accept(user, (Player)target), arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0));
        });
    }

    @Deprecated
    protected void loadTargetOrSenderDataAsync(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull UserManager userManager, @NotNull Consumer<Player> consumer) {
        String playerName = arguments.getString("player", context.getSender().getName());
        userManager.loadTargetPlayer(playerName).thenAcceptAsync((Consumer)consumer, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0));
    }

    protected boolean performForTargetOrSenderSync(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull UserManager userManager, @NotNull Consumer<Player> consumer) {
        String playerName;
        if (arguments.contains("player")) {
            playerName = arguments.getString("player");
        } else {
            if (!context.isPlayer()) {
                context.printUsage();
                return false;
            }
            playerName = context.getPlayerOrThrow().getName();
        }
        userManager.loadTargetPlayer(playerName).thenAcceptAsync(target -> {
            Player sender;
            CommandSender patt0$temp;
            if (target == null || (patt0$temp = context.getSender()) instanceof Player && !(sender = (Player)patt0$temp).canSee(target)) {
                context.errorBadPlayer();
                return;
            }
            consumer.accept((Player)target);
        }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0));
        return true;
    }
}

