/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.NodeExecutor;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.commands.tree.LiteralNode;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.CommandUtil;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandKey;
import su.nightexpress.sunlight.command.CommandSettings;
import su.nightexpress.sunlight.command.provider.CommandProvider;
import su.nightexpress.sunlight.command.provider.definition.HubDefinition;
import su.nightexpress.sunlight.command.provider.definition.LiteralDefinition;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.config.Perms;
import su.nightexpress.sunlight.user.SunUser;

public class CommandRegistry
extends SimpleManager<SunLightPlugin> {
    private final CommandSettings settings = new CommandSettings();
    private final Map<String, CommandProvider> providers = new LinkedHashMap<String, CommandProvider>();
    private final Set<NightCommand> commands = new HashSet<NightCommand>();

    public CommandRegistry(@NotNull SunLightPlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.settings.load(((SunLightPlugin)this.plugin).getConfig());
        this.registerCommands();
    }

    protected void onShutdown() {
        this.commands.forEach(NightCommand::unregister);
        this.commands.clear();
        this.providers.clear();
    }

    public void addProvider(@NotNull String id, @NotNull CommandProvider provider) {
        this.providers.put(LowerCase.INTERNAL.apply(id), provider);
    }

    private void registerCommands() {
        this.providers.forEach((providerId, provider) -> {
            FileConfig config = FileConfig.load((String)(String.valueOf(((SunLightPlugin)this.plugin).getDataFolder()) + "/commands/"), (String)FileConfig.withExtension((String)providerId));
            ((SunLightPlugin)this.plugin).injectLang((LangContainer)provider);
            provider.registerDefaults();
            provider.load(config);
            provider.getLiteralBuilders().forEach((nodeId, consumer) -> {
                LiteralDefinition literalDefinition = provider.getLiteralDefinitions().get(nodeId);
                if (literalDefinition == null || !literalDefinition.enabled()) {
                    return;
                }
                this.register((NightCommand)NightCommand.literal((NightPlugin)((NightPlugin)this.plugin), (String[])literalDefinition.aliases(), builder -> {
                    consumer.accept(builder);
                    if (this.settings.isCooldownsEnabled()) {
                        this.wrapExecutorWithCooldown((String)providerId, (String)nodeId, literalDefinition, (LiteralNodeBuilder)builder);
                    }
                }));
            });
            provider.getRootBuilders().forEach((rootId, rootBuilder) -> {
                HubDefinition rootDefinition = provider.getRootDefinitions().get(rootId);
                if (rootDefinition == null || !rootDefinition.enabled()) {
                    return;
                }
                ArrayList childrens = new ArrayList();
                provider.getLiteralBuilders().forEach((nodeId, consumer) -> {
                    String alias = rootDefinition.childrenAliases().get(nodeId);
                    if (alias == null || alias.isBlank()) {
                        return;
                    }
                    childrens.add(Commands.literal((String)alias, (Consumer)consumer));
                });
                if (childrens.isEmpty()) {
                    ((SunLightPlugin)this.plugin).warn("Root command '" + rootDefinition.name() + "' was not registered due to no sub-commands available.");
                    return;
                }
                this.register((NightCommand)NightCommand.hub((NightPlugin)((NightPlugin)this.plugin), (String[])rootDefinition.aliases(), builder -> {
                    rootBuilder.accept(builder);
                    builder.localized(rootDefinition.name());
                    builder.branch((ExecutableNode[])childrens.toArray(new LiteralNode[0]));
                }));
            });
            config.saveChanges();
        });
    }

    private void register(@NotNull NightCommand command) {
        if (this.settings.isConflictUnregisterEnabled()) {
            this.unregisterConflicts(command);
        }
        if (!command.register()) {
            ((SunLightPlugin)this.plugin).warn("Command '%s' was not registered with the passed in label, which indicates the SunLight's fallback prefix was used one or more time. This usually means that there is a vanilla command with the same label.");
        }
        this.commands.add(command);
    }

    @NotNull
    public Set<CommandProvider> getProviders() {
        return new HashSet<CommandProvider>(this.providers.values());
    }

    private void wrapExecutorWithCooldown(@NotNull String providerId, @NotNull String nodeId, @NotNull LiteralDefinition definition, @NotNull LiteralNodeBuilder builder) {
        NodeExecutor executor = builder.getExecutor();
        int cooldown = definition.cooldown();
        builder.executes((context, arguments) -> {
            Long expireDate;
            Player player = context.getPlayer();
            SunUser user = player == null ? null : (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
            CommandKey key = new CommandKey(providerId, nodeId);
            if (cooldown != 0 && user != null && !player.hasPermission(Perms.BYPASS_COMMAND_COOLDOWN) && (expireDate = user.getCommandCooldown(key)) != null && !TimeUtil.isPassed((long)expireDate)) {
                (expireDate < 0L ? Lang.COMMAND_COOLDOWN_ONE_TIME : Lang.COMMAND_COOLDOWN_DEFAULT).message().sendWith((CommandSender)player, replacer -> replacer.with("%time%", () -> TimeFormats.formatDuration((long)expireDate, (TimeFormatType)TimeFormatType.LITERAL)).with("%command%", () -> "/" + context.getInput()));
                return false;
            }
            boolean result = executor.run(context, arguments);
            if (result && cooldown != 0 && user != null) {
                long expireDate2 = TimeUtil.createFutureTimestamp((double)cooldown);
                user.setCommandCooldown(key, expireDate2);
                user.markDirty();
            }
            return result;
        });
    }

    private void unregisterConflicts(@NotNull NightCommand command) {
        HashSet<String> aliases = new HashSet<String>(command.getAliases());
        aliases.add(command.getName());
        aliases.forEach(alias -> CommandUtil.getCommand((String)alias).ifPresent(other -> {
            boolean result = CommandUtil.unregister((Command)other);
            String owner = CommandRegistry.getCommandOwner(other);
            if (this.settings.getConflictUnregisterBlacklist().contains(LowerCase.INTERNAL.apply(owner))) {
                return;
            }
            if (result) {
                ((SunLightPlugin)this.plugin).info("Unregistered conflicting '%s' (%s) command in favor of SunLight's alternative.".formatted(other.getName(), owner));
            } else {
                ((SunLightPlugin)this.plugin).warn("Could not unregister conflicting command '%s' (%s) in favor of SunLight's alternative.".formatted(other.getName(), owner));
            }
        }));
    }

    @NotNull
    private static String getCommandOwner(@NotNull Command command) {
        if (command instanceof PluginIdentifiableCommand) {
            PluginIdentifiableCommand identifiableCommand = (PluginIdentifiableCommand)command;
            return identifiableCommand.getPlugin().getName();
        }
        if (command instanceof BukkitCommand) {
            BukkitCommand bukkitCommand = (BukkitCommand)command;
            String permission = bukkitCommand.getPermission();
            if (permission != null && permission.startsWith("minecraft")) {
                return "Vanilla";
            }
            return "Bukkit";
        }
        return "Unknown";
    }
}

